/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.moving;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.PortalContext;
import org.gcube.portlets.user.moving.DatabaseConnection;
import org.gcube.portlets.user.moving.FilledForm;
import org.gcube.portlets.user.moving.createaccounts.CreateUserAccount;

/*
 * Exception performing whole class analysis ignored.
 */
public class ManageForms
extends MVCPortlet {
    private static Log _log = LogFactoryUtil.getLog(ManageForms.class);

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) {
        Connection conn = null;
        try {
            conn = DatabaseConnection.getInstance((String)("/" + PortalContext.getConfiguration().getInfrastructureName())).getConnection();
            _log.info((Object)"Trying getting FORMS from DB");
            List filledForms = ManageForms.getNonProcessedForms((Connection)conn);
            _log.info((Object)("Succesfully got Non Processed Form from DB, forms found: " + filledForms.size()));
            renderRequest.setAttribute("filledForms", (Object)filledForms);
            super.render(renderRequest, renderResponse);
        }
        catch (Exception e) {
            _log.error((Object)"Something wrong with Databaseconnection or with getting FORMS from DB", (Throwable)e);
        }
    }

    public static String getCurrentContext(long groupId) {
        try {
            PortalContext pContext = PortalContext.getConfiguration();
            return pContext.getCurrentScope("" + groupId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String formId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"applicationItemId", null);
        System.out.println("\n\n *** formId=" + formId);
        Connection conn = null;
        try {
            conn = DatabaseConnection.getInstance((String)("/" + PortalContext.getConfiguration().getInfrastructureName())).getConnection();
            FilledForm filledForm = ManageForms.getFormById((Connection)conn, (String)formId);
            _log.info((Object)"filledForm exists Trying UPDATE FORM ON DB");
            boolean user_accepted = true;
            this.setFormProcessedAndStateById(conn, formId, user_accepted);
            _log.info((Object)("UPDATED FORM ON DB to Accepted, formId=" + formId));
            try {
                _log.info((Object)"Sending email to user");
                Properties props = System.getProperties();
                Session session = null;
                props.put("mail.smtp.host", "localhost");
                props.put("mail.smtp.port", "25");
                session = Session.getDefaultInstance((Properties)props);
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress("MOVING Gateway <moving@d4science.org>"));
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)filledForm.getEmailAddress()));
                message.setSubject("MOVING EU Multi-Actor Platform: Expression of Interest application feedback");
                message.setText("Dear Sir/Madam,\n\nAfter a careful review and consideration of your expression of interest to join the MOVING EU-level Multi-Actor Platform (MAP), we are happy to inform you that your request has been accepted.\n\nYou will soon receive an email with link to access the EU MAP set up on the Virtual Research Environment (VRE). \n\nBest regards,\nMOVING team\n");
                Transport.send((Message)message);
            }
            catch (Exception e) {
                _log.error((Object)"Something wrong with sending email", (Throwable)e);
            }
            _log.info((Object)"Sending acceptance email done, adding user to the VRE and creating account if needed");
            HttpServletRequest httpRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest));
            CreateUserAccount.register((HttpServletRequest)httpRequest, (String)filledForm.getName(), (String)filledForm.getSurname(), (String)filledForm.getOrganisation(), (String)filledForm.getEmailAddress(), (boolean)true, (boolean)true, (Timestamp)filledForm.getDateCreated());
            _log.info((Object)"acceptApplication completed");
        }
        catch (Exception e) {
            _log.error((Object)"Something wrong with Database connection or with getting FORMS from DB", (Throwable)e);
        }
        JSONObject fileObject = JSONFactoryUtil.createJSONObject();
        fileObject.put("success", "OK");
        resourceResponse.getWriter().println(fileObject);
    }

    public void rejectApplication(ActionRequest request, ActionResponse actionResponse) throws IOException, PortletException {
        _log.info((Object)"rejecting form");
        String formId = ParamUtil.getString((PortletRequest)request, (String)"applicationItem");
        Connection conn = null;
        try {
            conn = DatabaseConnection.getInstance((String)("/" + PortalContext.getConfiguration().getInfrastructureName())).getConnection();
            FilledForm filledForm = ManageForms.getFormById((Connection)conn, (String)formId);
            _log.info((Object)"filledForm exists Trying UPDATE FORM ON DB");
            boolean user_accepted = false;
            this.setFormProcessedAndStateById(conn, formId, user_accepted);
            _log.info((Object)("UPDATED FORM ON DB to Rejected, formId=" + formId));
            _log.info((Object)"Sending email to user");
            Properties props = System.getProperties();
            Session session = null;
            props.put("mail.smtp.host", "localhost");
            props.put("mail.smtp.port", "25");
            session = Session.getDefaultInstance((Properties)props);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress("MOVING Gateway <moving@d4science.org>"));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)filledForm.getEmailAddress()));
            message.setSubject("MOVING EU Multi-Actor Platform: Expression of Interest application feedback");
            message.setText("Dear Sir/Madam,\n\nAfter a careful review and consideration of your expression of interest to join the MOVING EU-level Multi-Actor Platform (MAP), we regret to inform you that your request has not been granted. \n\nThe MOVING EU MAP aims to form a dynamic and relevant community, ensuring a balanced representation of actors at different levels and covering a diversity of topics and knowledge relevant to the core objective of the project.\n\nIf you would like to keep up to date with MOVING, please subscribe to our newsletter (https://mailchi.mp/4f25e203112c/movingnewsletter) or follow us online.\n\nThank you for your interest.\n\nBest regards,\nMOVING team\n");
            Transport.send((Message)message);
            _log.info((Object)"Sending Rejection email done");
        }
        catch (Exception e) {
            _log.error((Object)"Something wrong with Databaseconnection or with getting FORMS from DB", (Throwable)e);
        }
    }

    public void showAnswers(ActionRequest request, ActionResponse response) throws Exception {
        String formId = ParamUtil.getString((PortletRequest)request, (String)"applicationItem");
        Connection conn = null;
        try {
            conn = DatabaseConnection.getInstance((String)("/" + PortalContext.getConfiguration().getInfrastructureName())).getConnection();
            _log.info((Object)"Trying getting FORMS from DB");
            FilledForm filledForm = ManageForms.getFormById((Connection)conn, (String)formId);
            request.setAttribute("filledForm", (Object)filledForm);
            response.setWindowState(WindowState.MAXIMIZED);
            response.setRenderParameter("jspPage", "/html/manageforms/show_all_answers.jsp");
        }
        catch (Exception e) {
            _log.error((Object)"Something wrong with Databaseconnection or with getting FORMS from DB", (Throwable)e);
        }
    }

    private static List<FilledForm> getNonProcessedForms(Connection conn) throws Exception {
        _log.debug((Object)"getting forms from DB ");
        ArrayList<FilledForm> toReturn = new ArrayList<FilledForm>();
        String selectSQL = "SELECT * FROM forms WHERE processed_form = false";
        PreparedStatement preparedStatement = conn.prepareStatement(selectSQL);
        ResultSet rs = preparedStatement.executeQuery();
        while (rs.next()) {
            long id = rs.getLong("id");
            String name = rs.getString("name");
            String surname = rs.getString("surname");
            String organisation = rs.getString("organisation");
            String organisationType = rs.getString("organisation_type");
            String emailAddress = rs.getString("email");
            String areaOfExpertise = rs.getString("area_of_expertise");
            String country = rs.getString("country");
            boolean participatedInActivities = rs.getBoolean("activities_participation");
            String mainMotivation = rs.getString("main_motivation");
            String textareaMotivation = rs.getString("elaborated_motivation");
            String elaborated_expertise = rs.getString("elaborated_expertise");
            String degree_of_participation = rs.getString("degree_of_participation");
            boolean data_management = rs.getBoolean("data_management");
            Timestamp dateCreated = rs.getTimestamp("datecreated");
            boolean processed_form = rs.getBoolean("processed_form");
            boolean form_accepted = rs.getBoolean("user_accepted");
            FilledForm toAdd = new FilledForm(id, name, surname, organisation, organisationType, emailAddress, areaOfExpertise, country, participatedInActivities, mainMotivation, textareaMotivation, elaborated_expertise, degree_of_participation, data_management, dateCreated, processed_form, form_accepted);
            _log.info((Object)("Adding non processed form" + toAdd));
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private boolean setFormProcessedAndStateById(Connection conn, String formId, boolean user_accepted) {
        try {
            _log.debug((Object)"setFormProcessedAndStateById");
            String selectSQL = "UPDATE forms SET processed_form = ?, user_accepted = ? WHERE id = ? ";
            PreparedStatement preparedStatement = conn.prepareStatement(selectSQL);
            long idToLookFor = Long.parseLong(formId);
            preparedStatement.setBoolean(1, true);
            preparedStatement.setBoolean(2, user_accepted);
            preparedStatement.setLong(3, idToLookFor);
            int result = preparedStatement.executeUpdate();
            return result == 1;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static FilledForm getFormById(Connection conn, String formId) throws Exception {
        _log.debug((Object)"getting form by id from DB ");
        String selectSQL = "SELECT * FROM forms WHERE id = ? ";
        PreparedStatement preparedStatement = conn.prepareStatement(selectSQL);
        long idToLookFor = Long.parseLong(formId);
        preparedStatement.setLong(1, idToLookFor);
        ResultSet rs = preparedStatement.executeQuery();
        if (rs.next()) {
            long id = rs.getLong("id");
            String name = rs.getString("name");
            String surname = rs.getString("surname");
            String organisation = rs.getString("organisation");
            String organisationType = rs.getString("organisation_type");
            String emailAddress = rs.getString("email");
            String areaOfExpertise = rs.getString("area_of_expertise");
            String country = rs.getString("country");
            boolean participatedInActivities = rs.getBoolean("activities_participation");
            String mainMotivation = rs.getString("main_motivation");
            String textareaMotivation = rs.getString("elaborated_motivation");
            String elaborated_expertise = rs.getString("elaborated_expertise");
            String degree_of_participation = rs.getString("degree_of_participation");
            boolean data_management = rs.getBoolean("data_management");
            Timestamp dateCreated = rs.getTimestamp("datecreated");
            boolean processed_form = rs.getBoolean("processed_form");
            boolean form_accepted = rs.getBoolean("user_accepted");
            FilledForm toAdd = new FilledForm(id, name, surname, organisation, organisationType, emailAddress, areaOfExpertise, country, participatedInActivities, mainMotivation, textareaMotivation, elaborated_expertise, degree_of_participation, data_management, dateCreated, processed_form, form_accepted);
            _log.info((Object)("Adding non processed form" + toAdd));
            return toAdd;
        }
        return null;
    }
}

