/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.usersaccount;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.User;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.notifications.thread.NewUserAccountNotificationThread;
import org.gcube.portal.removeaccount.thread.RemoveUserTokenFromInfraThread;
import org.gcube.portal.removeaccount.thread.RemovedUserAccountThread;
import org.gcube.portal.usersaccount.WorkspaceCreateAccountThread;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyCreateUserAccountListener
extends BaseModelListener<User> {
    private static final Logger _log = LoggerFactory.getLogger(MyCreateUserAccountListener.class);
    final String SUBJECT = "New user account notification";
    private GroupManager gm;
    private RoleManager rm;

    public void onAfterCreate(User user) throws ModelListenerException {
        _log.info("onAfterCreate NewUserAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
        Thread WorkspaceAccountCreationThread = new Thread((Runnable)new WorkspaceCreateAccountThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
        WorkspaceAccountCreationThread.start();
        Thread emailManagersThread = new Thread((Runnable)new NewUserAccountNotificationThread(user.getScreenName(), user.getFullName(), user.getEmailAddress()));
        emailManagersThread.start();
    }

    public void onBeforeRemove(User user) throws ModelListenerException {
        this.gm = new LiferayGroupManager();
        this.rm = new LiferayRoleManager();
        _log.info("onBeforeRemove userAccount listener for: " + user.getScreenName() + " / " + user.getFullName());
        String username2Delete = user.getScreenName();
        _log.info("Trying to remove user from JCR and not notify infra-managers ...");
        try {
            _log.debug("Getting super user with role {}", (Object)GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
            long rootgroupId = this.gm.getGroupIdFromInfrastructureScope(infraContext);
            User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
            if (theAdmin == null) {
                System.out.println("Cannot add the user as VRE Folder admin: there is no user having role {} on context: " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            }
            String adminUsername = theAdmin.getScreenName();
            _log.info("Got the super user: {}", (Object)adminUsername);
            String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
            ArrayList<String> rolesString = new ArrayList<String>();
            List theAdminRoles = this.rm.listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
            for (GCubeRole gCubeRole : theAdminRoles) {
                rolesString.add(gCubeRole.getRoleName());
            }
            rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            Thread dropUserWorkspaceThread = new Thread((Runnable)new RemovedUserAccountThread(username2Delete, theAdminToken, rolesString));
            dropUserWorkspaceThread.start();
            _log.info("Trying to remove user from Auth ...");
            Thread deleteAllUserAuthThread = new Thread((Runnable)new RemoveUserTokenFromInfraThread(username2Delete));
            deleteAllUserAuthThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

