/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.ldapexport;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.gcube.common.portal.PortalContext;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;

public class LDAPSync
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(LDAPSync.class);
    private static final String LDAP_ORG_FILTER = "(objectClass=organizationalUnit)";
    private static final String LDAP_GROUP_FILTER = "(objectClass=posixGroup)";
    private static final String USER_CONTEXT = ",ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org";
    private static final String DEFAULT_GID_NUMBER = "1000";
    private static final String SSH_PUBLIC_KEY_ATTR = "SSH-public-key";
    private String ldapUrl;
    private String filter;
    private String principal;
    private String pwd;

    public LDAPSync(String ldapUrl, String filter, String principal, String pwd) {
        this.ldapUrl = ldapUrl;
        this.filter = filter;
        this.principal = principal;
        this.pwd = pwd;
        _log.info((Object)("Starting LDAPSync over " + ldapUrl));
    }

    private GCubeGroup getRootVO() {
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            String rootVoName = gm.getRootVOName();
            _log.debug((Object)("Root organization name found: " + rootVoName));
            return gm.getGroup(gm.getGroupIdFromInfrastructureScope("/" + rootVoName));
        }
        catch (Exception e) {
            _log.error((Object)"There were problems retrieving root VO group", (Throwable)e);
            _log.error((Object)"Could not find any root organization");
            return null;
        }
    }

    @Override
    public void run() {
        _log.debug((Object)"Reading Portal Users ...");
        List users = null;
        try {
            users = this.getAllLiferayUsers();
            _log.info((Object)("***Read " + users.size() + " from LR DB\n"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        _log.debug((Object)"Reading Portal Organizations ...");
        GCubeGroup rootVO = this.getRootVO();
        _log.debug((Object)"Initializing LDAP exporter ...");
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("java.naming.security.principal", this.principal);
        env.put("java.naming.security.credentials", this.pwd);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            _log.debug((Object)"Initiating LDAP Sync ...");
            this.createUsersOrganizationalUnit((DirContext)ctx);
            this.updateGroups((DirContext)ctx, rootVO);
            this.exportSingleUsers((DirContext)ctx, env, users);
        }
        catch (NamingException e) {
            _log.error((Object)"Something went Wrong during LDAP Sync in Exporting to LDAP");
            e.printStackTrace();
        }
        catch (Exception es) {
            _log.error((Object)"Something went Wrong during LDAP Sync in retrieving Liferay Organization");
            es.printStackTrace();
        }
    }

    private void createUsersOrganizationalUnit(DirContext ctx) throws NamingException {
        if (!this.checkIfLDAPOrganizationalUnitExists(ctx, "ou=Organizations,dc=d4science,dc=org")) {
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            objectClass.add("organizationalUnit");
            attributes.put(objectClass);
            BasicAttribute description = new BasicAttribute("description");
            description.add("Where to find users");
            attributes.put(description);
            ctx.createSubcontext("ou=Organizations,dc=d4science,dc=org", (Attributes)attributes);
            attributes = new BasicAttributes();
            objectClass = new BasicAttribute("objectClass");
            objectClass.add("Organization");
            attributes.put(objectClass);
            description.add("Default Organization");
            ctx.createSubcontext("o=D4Science,ou=Organizations,dc=d4science,dc=org", (Attributes)attributes);
            attributes = new BasicAttributes();
            objectClass = new BasicAttribute("objectClass");
            objectClass.add("organizationalUnit");
            attributes.put(objectClass);
            description.add("People Org Unit");
            ctx.createSubcontext("ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org", (Attributes)attributes);
        } else {
            _log.info((Object)"ou=Organizations,dc=d4science,dc=org already present, skip");
        }
    }

    private void updateGroups(DirContext ctx, GCubeGroup root) throws NamingException, SystemException {
        String subCtx = this.getOrgSubContext(root.getGroupName());
        if (!this.checkIfLDAPOrganizationalUnitExists(ctx, subCtx)) {
            this.createOrganizationalUnit(ctx, subCtx);
        }
        for (GCubeGroup vo : root.getChildren()) {
            String orgSubCtx = "ou=" + vo.getGroupName() + "," + subCtx;
            if (!this.checkIfLDAPOrganizationalUnitExists(ctx, orgSubCtx)) {
                this.createOrganizationalUnit(ctx, orgSubCtx);
            }
            for (GCubeGroup vre : vo.getChildren()) {
                String vreSubCtx = "cn=" + vre.getGroupName() + "," + orgSubCtx;
                if (!this.checkIfLDAPGroupExists(ctx, vreSubCtx)) {
                    this.createGroupVRE(ctx, vreSubCtx, vre.getGroupName());
                }
                this.updateUsersInGroup(ctx, vreSubCtx, vre);
            }
        }
    }

    private void updateUsersInGroup(DirContext ctx, String vreSubCtx, GCubeGroup vre) throws NamingException, SystemException {
        _log.debug((Object)("updateUsersInGroup: " + vre.getGroupName()));
        List users = new ArrayList();
        try {
            users = UserLocalServiceUtil.getGroupUsers((long)vre.getGroupId());
        }
        catch (Exception e) {
            _log.error((Object)("Could not retrieve members of vre: " + vre.getGroupName() + " having groupid: " + vre.getGroupId()), (Throwable)e);
        }
        for (User userObj : users) {
            String user = userObj.getScreenName();
            try {
                BasicAttribute memberUid = new BasicAttribute("memberUid");
                memberUid.add(user);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(memberUid);
                ctx.modifyAttributes(vreSubCtx, 1, (Attributes)attributes);
                _log.info((Object)("Adding user: " + user));
            }
            catch (AttributeInUseException ex) {
                _log.trace((Object)("Not adding already existing user: " + user));
            }
        }
    }

    private void exportSingleUsers(DirContext ctx, Properties env, List<User> users) throws Exception {
        for (User user : users) {
            String lastName = "NoLastNameEntered";
            if (user.getLastName() != null && user.getLastName().compareTo("") != 0) {
                lastName = user.getLastName();
            }
            _log.debug((Object)("Trying read  sshPublicKey for " + user.getScreenName()));
            String sshPublicKey = new LiferayUserManager().readCustomAttr(user.getUserId(), SSH_PUBLIC_KEY_ATTR).toString();
            if (user.getFirstName() != null && user.getFirstName().compareTo("") != 0) {
                this.updateUserInLDAP(user.getScreenName(), user.getFirstName(), lastName, user.getFullName(), user.getEmailAddress(), "{SHA}" + user.getPassword(), sshPublicKey, ctx, this.filter);
            }
            _log.debug((Object)("Updated " + user.getScreenName()));
        }
        _log.debug((Object)"LDAP Users Sync cycle done");
        if (!users.isEmpty()) {
            _log.info((Object)"LDAP Users Sync Completed OK!");
        } else {
            _log.warn((Object)"LDAP Users Sync cycle skipped this time");
        }
    }

    private void createOrganizationalUnit(DirContext ctx, String subContext) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("organizationalUnit");
        attributes.put(objectClass);
        BasicAttribute description = new BasicAttribute("description");
        description.add("Liferay Organization");
        attributes.put(description);
        ctx.createSubcontext(subContext, (Attributes)attributes);
        _log.info((Object)("Added " + subContext));
    }

    private void createGroupVRE(DirContext ctx, String subContext, String vreName) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("posixGroup");
        attributes.put(objectClass);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(vreName);
        attributes.put(cn);
        BasicAttribute gidNumber = new BasicAttribute("gidNumber");
        gidNumber.add(String.valueOf(this.getRandomPOSIXidentifier()));
        attributes.put(gidNumber);
        ctx.createSubcontext(subContext, (Attributes)attributes);
        _log.info((Object)("Added " + subContext));
    }

    private String getOrgSubContext(String orgName) {
        return "ou=" + orgName + ",dc=d4science,dc=org";
    }

    private boolean checkIfLDAPOrganizationalUnitExists(DirContext ctx, String orgSubctx) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search(orgSubctx, LDAP_ORG_FILTER, ctls);
        }
        catch (NamingException e) {
            _log.debug((Object)("not found in LDAP (will add it): Organization: " + orgSubctx));
            return false;
        }
        boolean toReturn = answer.hasMoreElements();
        _log.debug((Object)("Organization: " + orgSubctx + " exists? " + toReturn));
        return toReturn;
    }

    private boolean checkIfLDAPGroupExists(DirContext ctx, String groupSubctx) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search(groupSubctx, LDAP_GROUP_FILTER, ctls);
        }
        catch (NamingException e) {
            _log.debug((Object)("not found in LDAP (will add it): Group: " + groupSubctx));
            return false;
        }
        boolean toReturn = answer.hasMoreElements();
        _log.debug((Object)("Group: " + groupSubctx + " exists? " + toReturn));
        return toReturn;
    }

    private String getSubContext(String username) {
        return "uid=" + username + USER_CONTEXT;
    }

    private boolean checkIfLDAPUserExists(String username, DirContext ctx, String filter) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search(this.getSubContext(username), filter, ctls);
        }
        catch (NamingException e) {
            _log.info((Object)("user: " + username + " not found in LDAP, trying to export it"));
            return false;
        }
        return answer.hasMoreElements();
    }

    private void updateUserInLDAP(String username, String name, String lastName, String fullName, String email, String passwd, String sshPublicKey, DirContext ctx, String filter) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("inetOrgPerson");
        objectClass.add("posixAccount");
        objectClass.add("organizationalPerson");
        objectClass.add("person");
        objectClass.add("shadowAccount");
        objectClass.add("ldapPublicKey");
        attributes.put(objectClass);
        BasicAttribute givenName = new BasicAttribute("givenName");
        BasicAttribute cn = new BasicAttribute("cn");
        BasicAttribute sn = new BasicAttribute("sn");
        BasicAttribute mail = new BasicAttribute("mail");
        BasicAttribute userPassword = new BasicAttribute("userPassword");
        BasicAttribute gidNumber = new BasicAttribute("gidNumber");
        BasicAttribute homeDirectory = new BasicAttribute("homeDirectory");
        BasicAttribute shell = new BasicAttribute("loginShell");
        BasicAttribute sshPublicKeyAttr = new BasicAttribute("sshPublicKey");
        givenName.add(name);
        cn.add(fullName);
        sn.add(lastName);
        mail.add(email);
        userPassword.add(passwd);
        gidNumber.add(DEFAULT_GID_NUMBER);
        homeDirectory.add("/home/" + username);
        shell.add("/bin/bash");
        sshPublicKeyAttr.add(sshPublicKey);
        attributes.put(givenName);
        attributes.put(cn);
        attributes.put(sn);
        attributes.put(mail);
        attributes.put(userPassword);
        attributes.put(gidNumber);
        attributes.put(homeDirectory);
        attributes.put(shell);
        attributes.put(sshPublicKeyAttr);
        if (this.checkIfLDAPUserExists(username, ctx, filter)) {
            ctx.modifyAttributes(this.getSubContext(username), 2, (Attributes)attributes);
            _log.debug((Object)("Updated attributes for already existing user with uid=" + username));
        } else {
            int n = this.getRandomPOSIXidentifier();
            while (this.checkIfPosixUidNumberExists(ctx, n)) {
                _log.info((Object)("Found collision on UidNumber=" + n));
                n = this.getRandomPOSIXidentifier();
                _log.info((Object)("Trying newone=" + n));
            }
            BasicAttribute uidNumber = new BasicAttribute("uidNumber");
            attributes.put(uidNumber);
            uidNumber.add(String.valueOf(n));
            ctx.createSubcontext(this.getSubContext(username), (Attributes)attributes);
            _log.debug((Object)("New User Found with uid=" + username + " created"));
        }
    }

    private List<User> getAllLiferayUsers() {
        String infraName = PortalContext.getConfiguration().getInfrastructureName();
        _log.info((Object)("TRY Reading non chached users belonging to: /" + infraName));
        List<Object> toReturn = new ArrayList<User>();
        try {
            CacheRegistryUtil.clear();
            long groupId = new LiferayGroupManager().getGroupIdFromInfrastructureScope("/" + infraName);
            toReturn = UserLocalServiceUtil.getGroupUsers((long)groupId);
        }
        catch (Exception e) {
            _log.error((Object)("Error during LDAP Sync, could not retrieve users from LR DB: " + e.getMessage()));
        }
        return toReturn;
    }

    private int getRandomPOSIXidentifier() {
        int Low = 1000;
        int High = Integer.MAX_VALUE;
        Random r = new Random();
        int toReturn = r.nextInt(2147482647) + 1000;
        return toReturn;
    }

    private boolean checkIfPosixUidNumberExists(DirContext ctx, int numberToCheck) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search("ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org", "(uidNumber=" + numberToCheck + ")", ctls);
        }
        catch (NamingException e) {
            _log.info((Object)"exception");
            return false;
        }
        boolean toReturn = answer.hasMoreElements();
        _log.info((Object)("return " + toReturn));
        return toReturn;
    }
}

