/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.ldapexport;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.security.Key;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.ldapexport.LDAPSync;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class LDAPExportService
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(LDAPExportService.class);
    private static final String LDAP_SERVER_NAME = "LDAPServer";
    private static final String LDAP_SERVER_FILTER_NAME = "filter";
    private static final String LDAP_SERVER_PRINCPAL_NAME = "ldapPrincipal";
    private static final int LDAP_MINUTES_DELAY = 10;
    private String portalName;
    private String ldapUrl;
    private String filter;
    private String principal;
    private String ldapPassword;

    public void init() {
        this.portalName = PortalContext.getPortalInstanceName();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        query.addCondition("$resource/Profile/Name/text() eq '" + this.portalName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            _log.error((Object)("Could not find any Service endpoint registred in the infrastructure for this portal: " + this.portalName));
        } else if (list.size() > 1) {
            _log.warn((Object)("Found more than one Service endpoint registred in the infrastructure for this portal: " + this.portalName));
        } else {
            for (ServiceEndpoint res : list) {
                Group apGroup = res.profile().accessPoints();
                ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                for (int i = 0; i < accessPoints.length; ++i) {
                    if (accessPoints[i].name().compareTo(LDAP_SERVER_NAME) != 0) continue;
                    _log.info((Object)"Found credentials for LDAPServer");
                    ServiceEndpoint.AccessPoint found = accessPoints[i];
                    this.ldapUrl = found.address();
                    String encrPassword = found.password();
                    try {
                        this.ldapPassword = StringEncrypter.getEncrypter().decrypt(encrPassword, new Key[0]);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Something went wrong while decrypting password for LDAPServer");
                        e.printStackTrace();
                    }
                    Group propGroup = found.properties();
                    ServiceEndpoint.Property[] props = (ServiceEndpoint.Property[])propGroup.toArray((Object[])new ServiceEndpoint.Property[propGroup.size()]);
                    for (int j = 0; j < props.length; ++j) {
                        String encrValue;
                        if (props[j].name().compareTo(LDAP_SERVER_FILTER_NAME) == 0) {
                            _log.info((Object)"\tFound properties of filter");
                            encrValue = props[j].value();
                            System.out.println("Filter encrypted = " + encrValue);
                            try {
                                this.filter = StringEncrypter.getEncrypter().decrypt(encrValue, new Key[0]);
                            }
                            catch (Exception e) {
                                _log.error((Object)"Something went wrong while decrypting value for filter");
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (props[j].name().compareTo(LDAP_SERVER_PRINCPAL_NAME) != 0) continue;
                        _log.info((Object)"\tFound properties of ldapPrincipal");
                        encrValue = props[j].value();
                        try {
                            this.principal = StringEncrypter.getEncrypter().decrypt(encrValue, new Key[0]);
                            continue;
                        }
                        catch (Exception e) {
                            _log.error((Object)"Something went wrong while decrypting value for ldapPrincipal");
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ScheduledExecutorService ldapScheduler = Executors.newScheduledThreadPool(1);
        ldapScheduler.scheduleAtFixedRate((Runnable)new LDAPSync(this.ldapUrl, this.filter, this.principal, this.ldapPassword), 0L, 10L, TimeUnit.MINUTES);
        String toReturn = "<DIV>LDAPSync SCRIPT Started ... </DIV>";
        response.setContentType("text/html");
        response.getWriter().write(toReturn);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

