/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.landingpage;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import java.util.Date;
import java.util.List;
import org.gcube.portal.notifications.thread.NewUserSiteRegistrationNotificationThread;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCatalogueAndSBDLabRegistrationThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(ResourceCatalogueAndSBDLabRegistrationThread.class);
    private static long RESOURCE_CATALOGUE_GROUPID = 459909L;
    private static long SOBIGDATA_LAB_GROUPID = 20371853L;
    private User user;
    private Group resourceCatalogueGroup;
    private Group soBigDataLabGroup;
    private String siteURL;
    List<Group> userSites;
    UserManager um;

    public ResourceCatalogueAndSBDLabRegistrationThread(List<Group> userSites, User user, String siteURL) {
        this.user = user;
        this.userSites = userSites;
        this.siteURL = siteURL;
        this.um = new LiferayUserManager();
        try {
            this.resourceCatalogueGroup = GroupLocalServiceUtil.getGroup((long)RESOURCE_CATALOGUE_GROUPID);
            this.soBigDataLabGroup = GroupLocalServiceUtil.getGroup((long)SOBIGDATA_LAB_GROUPID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        boolean isRegisteredRC = false;
        boolean isRegisteredLAB = false;
        for (Group group : this.userSites) {
            if (group.getGroupId() != this.resourceCatalogueGroup.getGroupId()) continue;
            isRegisteredRC = true;
            _log.debug("user " + this.user.getFullName() + " is already registered to the VRE " + this.resourceCatalogueGroup.getName());
            break;
        }
        if (!isRegisteredRC) {
            try {
                _log.info("SBD Hook " + this.user.getFullName() + " going to be registered to the VRE " + this.resourceCatalogueGroup.getName());
                this.registerUserToVRE(this.user, this.resourceCatalogueGroup, this.siteURL);
            }
            catch (SystemException e) {
                _log.error("Could not register to " + this.resourceCatalogueGroup.getName());
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(3000L);
            _log.info("SBD Hook checking the VRE " + this.soBigDataLabGroup.getName());
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (Group group : this.userSites) {
            if (group.getGroupId() != this.soBigDataLabGroup.getGroupId()) continue;
            isRegisteredLAB = true;
            _log.debug("user " + this.user.getFullName() + " is already registered to the VRE " + this.soBigDataLabGroup.getName());
            break;
        }
        if (!isRegisteredLAB) {
            try {
                _log.info("SBD Hook " + this.user.getFullName() + "  going to be registered to the  VRE " + this.soBigDataLabGroup.getName());
                this.registerUserToVRE(this.user, this.soBigDataLabGroup, this.siteURL);
            }
            catch (SystemException e) {
                _log.error("Could not register to " + this.soBigDataLabGroup.getName());
                e.printStackTrace();
            }
        }
    }

    protected void registerUserToVRE(User user, Group vre, String siteURL) throws SystemException {
        try {
            this.um.requestMembership(user.getUserId(), vre.getGroupId(), "Automatic Request at " + new Date());
            _log.info("fakeRequest sent");
            String replierUsername = LiferayUserManager.getAdmin().getScreenName();
            _log.trace("Sleep 1 second ...");
            Thread.sleep(2000L);
            this.um.acceptMembershipRequest(user.getUserId(), vre.getGroupId(), true, replierUsername, "Automatic acceptance request at " + new Date());
            _log.info("fakeRequest accepted");
            _log.info("User " + user.getScreenName() + " automatically registered to " + vre.getName());
            Thread emailSiteManagersThread = new Thread((Runnable)new NewUserSiteRegistrationNotificationThread((UserManager)new LiferayUserManager(), (RoleManager)new LiferayRoleManager(), user, vre, siteURL));
            emailSiteManagersThread.start();
        }
        catch (Exception e) {
            _log.error("registerUserToVRE FAILED for: " + vre.getName());
            e.printStackTrace();
        }
    }
}

