package org.gcube.portal.istischeduler;

import java.util.List;

import org.gcube.portal.istischeduler.ex.UserManagementSystemException;
import org.gcube.portal.istischeduler.ex.UserRetrievalFault;
import org.gcube.portal.istischeduler.model.PortalUserModel;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public interface PortalUserManager {
	/**
	 * The username of one administrator is needed to perform this operation
	 * @param user2Add {@link PortalUserModel}
	 * @return true if ok fals otherwise
	 * @throws UserManagementSystemException 
	 * @throws UserRetrievalFault 
	 */
	boolean createUser(PortalUserModel user2Add) throws UserManagementSystemException, UserRetrievalFault;
	/**
	 * @param user2Update {@link PortalUserModel}
	 * @return true if ok fals otherwise
	 * @throws UserRetrievalFault 
	 * @throws UserManagementSystemException 
	 */
	boolean updateUser(PortalUserModel user2Update) throws UserManagementSystemException, UserRetrievalFault;
	/**
	 * @param username the username (screenname) of the user to deactivate
	 * @return true if ok false otherwise
	 * @throws UserRetrievalFault 
	 * @throws UserManagementSystemException 
	 */
	boolean deactivateUser(String username) throws UserManagementSystemException, UserRetrievalFault;
	/**
	 * @param username the username (screenname) of the user to delete
	 * @return true if ok false otherwise
	 * @throws UserRetrievalFault 
	 * @throws UserManagementSystemException 
	 */
	boolean deleteUser(String username) throws UserManagementSystemException, UserRetrievalFault;
	/**
	 * 
	 * @param username
	 * @return an instance of {@link PortalUserModel}
	 * @throws UserManagementSystemException 
	 */
	PortalUserModel getUserByUsername(String username) throws UserManagementSystemException;
	/**
	 * 
	 * @param fiscalCode
	 * @return an instance of {@link PortalUserModel}
	 * @throws UserManagementSystemException 
	 */
	PortalUserModel getUserByFiscalCode(String fiscalCode) throws UserManagementSystemException;	
	/**
	 * 
	 * @return the list of the current users in the portal as {@link PortalUserModel} istances
	 * @throws UserManagementSystemException 
	 */
	List<PortalUserModel> listPortalUsers() throws UserManagementSystemException;
}
