package org.gcube.portal.istischeduler.model;



/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 * 
 * 
 * User Object Model
 */
public class PortalUserModel{
		
	private String username;
	
	private String firstname;
	
	private String lastname;
	
	private String email;
	
	private String fiscalCode;
	
	private String optionalIdentifier;
	
	private String position;
	
	private String groups;
	
	public PortalUserModel(String username, String firstname, String lastname,
			String email, String fiscalCode, String optionalIdentifier,
			String position, String groups) {
		super();
		this.username = username;
		this.firstname = firstname;
		this.lastname = lastname;
		this.email = email;
		this.fiscalCode = fiscalCode;
		this.optionalIdentifier = optionalIdentifier;
		this.position = position;
		this.groups = groups;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getFirstname() {
		return firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	public String getLastname() {
		return lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFiscalCode() {
		return fiscalCode;
	}

	public void setFiscalCode(String fiscalCode) {
		this.fiscalCode = fiscalCode;
	}

	public String getOptionalIdentifier() {
		return optionalIdentifier;
	}

	public void setOptionalIdentifier(String optionalIdentifier) {
		this.optionalIdentifier = optionalIdentifier;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String getGroups() {
		return groups;
	}

	public void setGroups(String groups) {
		this.groups = groups;
	}

	@Override
	public String toString() {
		return "PortalUserModel [username=" + username + ", firstname="
				+ firstname + ", lastname=" + lastname + ", email=" + email
				+ ", fiscalCode=" + fiscalCode + ", optionalIdentifier="
				+ optionalIdentifier + ", position=" + position + ", groups="
				+ groups + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((email == null) ? 0 : email.hashCode());
		result = prime * result
				+ ((firstname == null) ? 0 : firstname.hashCode());
		result = prime * result
				+ ((fiscalCode == null) ? 0 : fiscalCode.hashCode());
		result = prime * result + ((groups == null) ? 0 : groups.hashCode());
		result = prime * result
				+ ((lastname == null) ? 0 : lastname.hashCode());
		result = prime
				* result
				+ ((optionalIdentifier == null) ? 0 : optionalIdentifier
						.hashCode());
		result = prime * result
				+ ((position == null) ? 0 : position.hashCode());
		result = prime * result
				+ ((username == null) ? 0 : username.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		PortalUserModel other = (PortalUserModel) obj;
		if (email == null) {
			if (other.email != null)
				return false;
		} else if (!email.equals(other.email))
			return false;
		if (firstname == null) {
			if (other.firstname != null)
				return false;
		} else if (!firstname.equals(other.firstname))
			return false;
		if (fiscalCode == null) {
			if (other.fiscalCode != null)
				return false;
		} else if (!fiscalCode.equals(other.fiscalCode))
			return false;
		if (groups == null) {
			if (other.groups != null)
				return false;
		} else if (!groups.equals(other.groups))
			return false;
		if (lastname == null) {
			if (other.lastname != null)
				return false;
		} else if (!lastname.equals(other.lastname))
			return false;
		if (optionalIdentifier == null) {
			if (other.optionalIdentifier != null)
				return false;
		} else if (!optionalIdentifier.equals(other.optionalIdentifier))
			return false;
		if (position == null) {
			if (other.position != null)
				return false;
		} else if (!position.equals(other.position))
			return false;
		if (username == null) {
			if (other.username != null)
				return false;
		} else if (!username.equals(other.username))
			return false;
		return true;
	}
	

}