package org.gcube.portal.istischeduler.model;

import java.util.Date;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public class SiEntry {
	
	private long id;
	private String table;
	private String operation;
	private long idFlow;
	private Date lastUpdate;
	/**
	 * 
	 * @param id  t_sistema_informativo_id
	 * @param table t_sistema_informativo_tabella
	 * @param operation t_sistema_informativo_operazioni
	 * @param idFlow t_sistema_informativo_id_flusso
	 * @param lastUpdate t_sistema_informativo_last_update
	 */
	public SiEntry(long id, String table, String operation, long idFlow,
			Date lastUpdate) {
		super();
		this.id = id;
		this.table = table;
		this.operation = operation;
		this.idFlow = idFlow;
		this.lastUpdate = lastUpdate;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}

	public String getOperation() {
		return operation;
	}

	public void setOperation(String operation) {
		this.operation = operation;
	}

	public long getIdFlow() {
		return idFlow;
	}

	public void setIdFlow(long idFlow) {
		this.idFlow = idFlow;
	}

	public Date getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(Date lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	@Override
	public String toString() {
		return "SiEntry [id=" + id + ", table=" + table + ", operation="
				+ operation + ", idFlow=" + idFlow + ", lastUpdate="
				+ lastUpdate + "]";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (id ^ (id >>> 32));
		result = prime * result + (int) (idFlow ^ (idFlow >>> 32));
		result = prime * result
				+ ((lastUpdate == null) ? 0 : lastUpdate.hashCode());
		result = prime * result
				+ ((operation == null) ? 0 : operation.hashCode());
		result = prime * result + ((table == null) ? 0 : table.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SiEntry other = (SiEntry) obj;
		if (id != other.id)
			return false;
		if (idFlow != other.idFlow)
			return false;
		if (lastUpdate == null) {
			if (other.lastUpdate != null)
				return false;
		} else if (!lastUpdate.equals(other.lastUpdate))
			return false;
		if (operation == null) {
			if (other.operation != null)
				return false;
		} else if (!operation.equals(other.operation))
			return false;
		if (table == null) {
			if (other.table != null)
				return false;
		} else if (!table.equals(other.table))
			return false;
		return true;
	}
	
	
}
