package org.gcube.portal.istischeduler;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import org.gcube.portal.istischeduler.model.SiEntry;
import org.gcube.portal.istischeduler.model.SiServerEntry;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public interface SiManager {
	/**
	 * 
	 * @param entry {@link SiEntry}
	 * @return true if the operation is successful
	 * @throws SQLException 
	 */
	boolean addSiEntry(SiEntry entry) throws SQLException;
	/**
	 * 
	 * @param entry {@link SiEntry}
	 * @return true if the operation is successful
	 * @throws SQLException 
	 */
	boolean updateSiEntry(SiEntry toUpdate) throws SQLException;
	/**
	 * 
	 * @param id the id to look for
	 * @return the {@link SiEntry} instance or null if not exist
	 * @throws SQLException 
	 */
	SiEntry getSiEntryById(long id) throws SQLException;
	/**
	 * 
	 * @return alist of entries
	 * @throws SQLException 
	 */
	List<SiEntry> listSiEntries() throws SQLException;
	/**
	 * 
	 * @param id t_sistema_informativo_sync_log_id
	 * @param logDate t_sistema_informativo_sync_log_data
	 * @param logResult t_sistema_informativo_sync_log_result
	 * @param logInfo t_sistema_informativo_sync_log_info
	 * @return true if the operation is successful
	 * @throws SQLException 
	 */
	boolean addSiLogEntry(long id, Date logDate, String logResult, String logInfo) throws SQLException;
	
	/**
	 * 
	 * @return the endpoint of the si database
	 */
	SiServerEntry getSiEndPoint();

}
