package org.gcube.portal.istischeduler.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.gcube.portal.istischeduler.PortalUserManager;
import org.gcube.portal.istischeduler.ex.UserManagementSystemException;
import org.gcube.portal.istischeduler.ex.UserRetrievalFault;
import org.gcube.portal.istischeduler.model.PortalUserModel;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
/**
 * 
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public class LiferayPortalUserManager implements PortalUserManager {
	
	private static final String ADMINISTRATOR_USERNAME = "massimiliano.assante";
	private static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";
	private final static String POSITION = "POSITION";
	private final static String LABS = "LABS";
	private final static String FISCAL_CODE = "FISCAL_CODE";
	private final static String OPTIONAL_IDENTIFIER = "OPTIONAL_IDENTIFIER";

	public LiferayPortalUserManager() {
		super();		
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean createUser(PortalUserModel user2Add) throws UserManagementSystemException, UserRetrievalFault {

		try {
			long companyId = getCompany().getCompanyId();

			User user = UserLocalServiceUtil.getUserByScreenName(companyId, ADMINISTRATOR_USERNAME);
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user, false);
			PermissionThreadLocal.setPermissionChecker(permissionChecker);

			String password1 = null;
			Locale locale = new Locale("en_US");
			ServiceContext serviceContext = new ServiceContext();
			String password2 = null;		
	
			User toAdd = UserLocalServiceUtil.addUser(
					0L, companyId, true, password1, password2, false, 
					user2Add.getUsername(), user2Add.getEmail(), 0L,"",
					locale, user2Add.getFirstname(), "mn", user2Add.getLastname(), 0, 0, true, 
					1, 1, 1940, "", null, null, null, null, true, serviceContext);
			
			//add the custom attrs
			if (! toAdd.getExpandoBridge().hasAttribute(POSITION)) 	toAdd.getExpandoBridge().addAttribute(POSITION);
			if (! toAdd.getExpandoBridge().hasAttribute(LABS)) 	toAdd.getExpandoBridge().addAttribute(LABS);
			if (! toAdd.getExpandoBridge().hasAttribute(FISCAL_CODE)) toAdd.getExpandoBridge().addAttribute(FISCAL_CODE);
			if (! toAdd.getExpandoBridge().hasAttribute(OPTIONAL_IDENTIFIER)) toAdd.getExpandoBridge().addAttribute(OPTIONAL_IDENTIFIER);
			
			toAdd.getExpandoBridge().setAttribute(POSITION, user2Add.getPosition());
			toAdd.getExpandoBridge().setAttribute(LABS, user2Add.getGroups());
			toAdd.getExpandoBridge().setAttribute(FISCAL_CODE, user2Add.getFiscalCode());
			toAdd.getExpandoBridge().setAttribute(OPTIONAL_IDENTIFIER, user2Add.getOptionalIdentifier());
		} catch (SystemException e) {
			throw new UserManagementSystemException("Error creating user ",user2Add.getUsername(), e);
		} catch (PortalException e) {			
			throw new UserRetrievalFault("Error adding user with screen name ",user2Add.getUsername(),e);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean updateUser(PortalUserModel user2Update) throws UserManagementSystemException, UserRetrievalFault {
		try {
			User user = null;
			try {
				long companyId = getCompany().getCompanyId();
				user = UserLocalServiceUtil.getUserByScreenName(companyId, user2Update.getUsername());
				user.setEmailAddress(user2Update.getEmail());
				user.setFirstName(user2Update.getFirstname());
				user.setLastName(user2Update.getLastname());
				user.getExpandoBridge().setAttribute(FISCAL_CODE, user2Update.getFiscalCode());
				user.getExpandoBridge().setAttribute(OPTIONAL_IDENTIFIER, user2Update.getOptionalIdentifier());
			}catch (PortalException e) {
				throw new UserRetrievalFault("Error retrieving user by screen name ",user2Update.toString(), e);
			}
			UserLocalServiceUtil.updateUser(user);
		} catch (SystemException e) {
			throw new UserManagementSystemException("Error updating user  ",user2Update.toString(), e);
		}
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public PortalUserModel getUserByUsername(String username) throws UserManagementSystemException {
		User user = null;
		PortalUserModel um = null;
		try {
			long companyId = getCompany().getCompanyId();
			user = UserLocalServiceUtil.getUserByScreenName(companyId, username);
			String position = (user.getExpandoBridge().getAttribute(POSITION) != null) ? user.getExpandoBridge().getAttribute(POSITION).toString() : "";
			String labs =  (user.getExpandoBridge().getAttribute(LABS) != null) ? user.getExpandoBridge().getAttribute(LABS).toString() : "";
			String fiscalCode = (user.getExpandoBridge().getAttribute(FISCAL_CODE) != null) ? user.getExpandoBridge().getAttribute(FISCAL_CODE).toString() : "";
			String optionalId = (user.getExpandoBridge().getAttribute(OPTIONAL_IDENTIFIER) != null) ? user.getExpandoBridge().getAttribute(OPTIONAL_IDENTIFIER).toString() : "";
			um = new PortalUserModel(
					user.getScreenName(), 
					user.getFirstName(), 
					user.getLastName(), 
					user.getEmailAddress(),
					fiscalCode,
					optionalId,
					position, 
					labs
					);
		} catch (SystemException e) {
			throw new UserManagementSystemException("Error retrieving user by screename  ", username, e);
		} catch (PortalException e) {
			throw new UserManagementSystemException("Error retrieving user by screename  ", username, e);
		}
		return um;
	}
	/**
	 * {@inheritDoc}
	 * @throws UserManagementSystemException 
	 */
	@Override
	public PortalUserModel getUserByFiscalCode(String fiscalCode) throws UserManagementSystemException {
		for (PortalUserModel user : listPortalUsers()) {
			if (user.getFiscalCode().compareTo(fiscalCode) == 0)
				return user;
		}
		return null;
	}
	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<PortalUserModel> listPortalUsers() throws UserManagementSystemException {
		List<User> users = null;
		List<PortalUserModel> userModels = new ArrayList<PortalUserModel>();
		try {
			users = UserLocalServiceUtil.getUsers(0, UserLocalServiceUtil.getUsersCount());
			for(User user : users){
				String position = (user.getExpandoBridge().getAttribute(POSITION) != null) ? user.getExpandoBridge().getAttribute(POSITION).toString() : "";
				String labs =  (user.getExpandoBridge().getAttribute(LABS) != null) ? user.getExpandoBridge().getAttribute(LABS).toString() : "";
				String fiscalCode = (user.getExpandoBridge().getAttribute(FISCAL_CODE) != null) ? user.getExpandoBridge().getAttribute(FISCAL_CODE).toString() : "";
				String optionalId = (user.getExpandoBridge().getAttribute(OPTIONAL_IDENTIFIER) != null) ? user.getExpandoBridge().getAttribute(OPTIONAL_IDENTIFIER).toString() : "";
			
				PortalUserModel um = new PortalUserModel(
						user.getScreenName(), 
						user.getFirstName(), 
						user.getLastName(), 
						user.getEmailAddress(),
						fiscalCode,
						optionalId,
						position,
						labs
						);
				userModels.add(um);
			}
		}catch (SystemException e) {
			throw new UserManagementSystemException("Error retrieving list of users ", e);
		}
		return userModels;
	}

	/**
	 * return the companyId
	 * @param webId .
	 * @return the company bean
	 * @throws PortalException .
	 * @throws SystemException .
	 */
	public static Company getCompany() throws PortalException, SystemException {
		return CompanyLocalServiceUtil.getCompanyByWebId(getDefaultCompanyWebId());
	}
	/**
	 * 
	 * @return the default company web-id (e.g. iMarine.eu)
	 */
	public static String getDefaultCompanyWebId() {
		String defaultWebId = "";
		try {
			defaultWebId = GetterUtil.getString(PropsUtil.get("company.default.web.id"));
		}
		catch (NullPointerException e) {
			System.out.println("Cound not find property company.default.web.id in portal.ext file returning default web id: " + DEFAULT_COMPANY_WEB_ID);
			return DEFAULT_COMPANY_WEB_ID;
		}
		return defaultWebId;
	}
}
