/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal;

import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.RoleModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class HomeLibraryGroupsCreator
extends HttpServlet {
    public void init() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String toReturn = "<h1>Home Library Groups Creator</h1>";
        ScopeProvider.instance.set("/" + HomeLibraryGroupsCreator.getRootOrganizationName());
        LiferayGroupManager gm = new LiferayGroupManager();
        LiferayUserManager um = new LiferayUserManager();
        LiferayRoleManager rm = new LiferayRoleManager();
        try {
            for (Organization vre : this.getPortalVREs()) {
                GroupModel group = gm.getGroup("" + vre.getOrganizationId());
                String groupId = group.getGroupId();
                if (!gm.isVRE(groupId).booleanValue()) continue;
                String vreName = group.getGroupName();
                String vreScope = gm.getScope(groupId);
                toReturn = toReturn + "<div>Getting users for vre: " + vreName + " scope=" + vreScope;
                toReturn = toReturn + "<ol>";
                List users = um.listUsersByGroup(group.getGroupId());
                for (UserModel user : users) {
                    toReturn = toReturn + "<li>" + user.getScreenName() + "</li>";
                }
                toReturn = toReturn + "</ol>";
                toReturn = toReturn + "<div>Getting VRE Managers for VRE: " + vreName + " scope=" + vreScope;
                toReturn = toReturn + "<ul>";
                rm.listRolesByGroup(group.getGroupId());
                HashMap userRoles = um.listUsersAndRolesByGroup(groupId);
                String vreManagerUserName = null;
                for (UserModel user : userRoles.keySet()) {
                    for (RoleModel role : (List)userRoles.get(user)) {
                        if (role == null || !role.getRoleName().equals("VRE-Manager")) continue;
                        toReturn = toReturn + "<li>" + user.getScreenName() + "</li>";
                        vreManagerUserName = user.getScreenName();
                    }
                }
                if (vreManagerUserName != null) {
                    Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(vreManagerUserName).getWorkspace();
                    GCubeGroup gGroup = HomeLibraryGroupsCreator.createGroup((String)vreScope, (List)users);
                    String groupid = gGroup == null ? vreScope : gGroup.getName();
                    WorkspaceSharedFolder wSharedFolder = HomeLibraryGroupsCreator.createVREFolder((String)vreScope, (String)vreName, (String)groupid, (Workspace)ws);
                    ArrayList<String> groups = new ArrayList<String>();
                    groups.add(gGroup.getName());
                    wSharedFolder.setACL(groups, ACLType.WRITE_OWNER);
                } else {
                    toReturn = toReturn + "<span style=\"color: red; font-size: 24px;\">ERROR, NO VRE-MANAGER FOUND IN THIS VRE</span>";
                    System.out.println("NO VRE-MANAGER");
                }
                toReturn = toReturn + "</div>";
                toReturn = toReturn + "<ul>";
                toReturn = toReturn + "</div>";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setContentType("text/html");
        response.getWriter().write(toReturn);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private static String getRootOrganizationName() {
        return PortalContext.getConfiguration().getInfrastructureName();
    }

    private static WorkspaceSharedFolder createVREFolder(String vreScope, String vreName, String groupId, Workspace ws) throws Exception {
        WorkspaceSharedFolder folder = ws.createSharedFolder(vreScope, "Special Shared folder for VRE " + vreName, groupId, ws.getRoot().getId(), vreName, true);
        System.out.println(folder.getPath());
        return folder;
    }

    private static GCubeGroup createGroup(String vreScope, List<UserModel> usersToAdd) throws InternalErrorException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        GCubeGroup group = gm.createGroup(vreScope);
        for (UserModel user : usersToAdd) {
            group.addMember(user.getScreenName());
        }
        return group;
    }

    private ArrayList<Organization> getPortalVREs() throws Exception {
        ArrayList<Organization> toReturn = new ArrayList<Organization>();
        Organization rootOrganization = null;
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        for (Organization organization : organizations) {
            if (!organization.getName().equals(HomeLibraryGroupsCreator.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        for (Organization vOrg : rootOrganization.getSuborganizations()) {
            for (Organization vre : vOrg.getSuborganizations()) {
                toReturn.add(vre);
            }
        }
        return toReturn;
    }
}

