package org.gcube.portlets.d4sreporting.common.shared;

import java.io.Serializable;
import java.util.ArrayList;
/**
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * Groups a list of Components, useful for repetitive elements
 *
 */
@SuppressWarnings("serial")
public class SerializableRepeatableSequence implements Serializable {

	private ArrayList<SerializableComponent> groupedComponents;
	private int height;

	public SerializableRepeatableSequence() {
		super();
	}
	
	public SerializableRepeatableSequence(ArrayList<SerializableComponent> groupedComponents, int height) {
		super();
		this.height = height;
		this.groupedComponents = groupedComponents;
	}

	public ArrayList<SerializableComponent> getGroupedComponents() {
		return groupedComponents;
	}

	public void setGroupedComponents(
			ArrayList<SerializableComponent> groupedComponents) {
		this.groupedComponents = groupedComponents;
	}
	
	public int getHeight() {
		return height;
	}


	public void setHeight(int height) {
		this.height = height;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((groupedComponents == null) ? 0 : groupedComponents
						.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SerializableRepeatableSequence other = (SerializableRepeatableSequence) obj;
		if (groupedComponents == null) {
			if (other.groupedComponents != null)
				return false;
		} else if (!groupedComponents.equals(other.groupedComponents))
			return false;
		return true;
	}

	@Override
	public String toString() {
		String toReturn = "SerializableRepeatableSequence: groupedComponents=";
		for (SerializableComponent sc : groupedComponents) {
			if (sc.getPossibleContent() != null)
				toReturn += sc.getPossibleContent().toString() + " ";			
		}
		return toReturn;
	}	
}
