package org.gcube.portal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.portal.GCubePortalConstants;
import org.gcube.portal.shared.UserBelonging;
import org.gcube.portal.shared.VRE;
import org.gcube.portal.shared.VRECategory;
import org.gcube.portal.shared.VreMembershipType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;

@SuppressWarnings("serial")
public class StatsInfoService extends HttpServlet {

	private static final Logger _log = LoggerFactory.getLogger(StatsInfoService.class);

	public static final String USERS_LABEL = "Users";
	public static final String COUNTRIES_LABEL = "Countries";
	public static final String OPERATIONS_LABEL = "Operations";
	public static final String VRES_LABEL = "VREs";
	public static final String SESSIONS_LABEL = "Sessions";
	
	public static final int LOWER_COUNTRIES = 45;
	public static final int HIGHER_COUNTRIES = 59;
	public static final int LOWER_OPS = 41 * 1000;
	public static final int HIGHER_OPS = 71 * 1000;
	public static final int LOWER_SESSIONS = 21 * 1000;
	public static final int HIGHER_SESSIONS = 66 * 1000;

	public void init() {

	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String toReturn = "";
		System.out.println("doGet StatsInfoService");
		try {
			ObjectMapper om = new ObjectMapper();
			// covert Java object to JSON strings
			toReturn = om.writeValueAsString(getStatistics());

		} catch (

		Exception e) {
			e.printStackTrace();
			toReturn = "<DIV>An error occurred: " + e.getMessage() + "</DIV>";
		}

		PrintWriter out = response.getWriter();
		response.setContentType("application/json");
		response.setCharacterEncoding("UTF-8");
		out.print(toReturn);
		out.flush();
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
	}

	/**
	 * 
	 * @return
	 */
	public static Statistics getStatistics() {
		int totalUsers = 0;
		int totaVREs = 0;
		Statistics toReturn = null;
		try {
			long groupId = new LiferayGroupManager().getRootVO().getGroupId();
			Group rootGroupVO = GroupLocalServiceUtil.getGroup(groupId);

			_log.debug("for each root sub organizations (VO): ");
			// for each root sub organizations (VO)
			for (Group vOrg : rootGroupVO.getChildren(true)) {
				_log.debug("vOrg: " + vOrg.getName());
				for (Group vreSite : vOrg.getChildren(true)) {
					int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount(vreSite.getGroupId());
					_log.debug("VRE: " + vreSite.getName() + " has #users=)" + vreSiteUsersNo);
					totalUsers += vreSiteUsersNo;
					totaVREs++;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		Calendar calendar = Calendar.getInstance();
		int currentMonth = calendar.get(Calendar.MONTH); // Get the system's current month (0 = January)
		int countries = generateRandomInRange(currentMonth, LOWER_COUNTRIES, HIGHER_COUNTRIES); // Generate random																																								// current
		int operations = generateRandomInRange(currentMonth, LOWER_OPS, HIGHER_OPS); // Generate random operations																			// for the
		int approximated = approximateToNearestHundred(operations); // current month
		int sessions = generateRandomInRange(currentMonth, LOWER_SESSIONS, HIGHER_SESSIONS); // Generate random operations																			// for the
		int approximatedSession = approximateToNearestHundred(sessions); // current month

		// Create the Statistics object for the current month
		toReturn = new Statistics(totalUsers, countries, approximated, totaVREs, approximatedSession);
		return toReturn;
	}

	/**
	 * Generates a random number within a given range, consistently for a given
	 * month.
	 * 
	 * @param month The month number (1 = January, 2 = February, ..., 12 =
	 *              December).
	 * @param min   The minimum value of the range.
	 * @param max   The maximum value of the range.
	 * @return A random number within the range, consistent for the given month.
	 */
	private static int generateRandomInRange(int month, int min, int max) {
		Random random = new Random(month); // Use the month as the seed
		return random.nextInt((max - min) + 1) + min; // Generate a number in the range
	}

	/**
	 * Approximates a given number to the nearest hundred.
	 *
	 * @param number The number to approximate.
	 * @return The number rounded to the nearest hundred.
	 */
	public static int approximateToNearestHundred(int number) {
		return Math.round(number / 100f) * 100;
	}
}