package org.gcube.portal;

public class Statistics {
	
	

	private Users users;
	private Countries countries;
	private Operations operations;
	private Vres vres;
	private Sessions sessions;

	public Statistics(int usersValue, int countriesValue, int operationsValue, int vresValue, int sessionsValue) {
        this.users = new Users(usersValue, StatsInfoService.USERS_LABEL);
        this.countries = new Countries(countriesValue, StatsInfoService.COUNTRIES_LABEL);
        this.operations = new Operations(operationsValue, StatsInfoService.OPERATIONS_LABEL);
        this.vres = new Vres(vresValue, StatsInfoService.VRES_LABEL);
        this.sessions = new Sessions(sessionsValue, StatsInfoService.SESSIONS_LABEL);
    }

	public Users getUsers() {
		return users;
	}

	public void setUsers(int value, String label) {
		this.users = new Users(value, label);
	}

	public Countries getCountries() {
		return countries;
	}

	public void setCountries(int value, String label) {
		this.countries = new Countries(value, label);
	}

	public Operations getOperations() {
		return operations;
	}

	public void setOperations(int value, String label) {
		this.operations = new Operations(value, label);
	}

	public Vres getVres() {
		return vres;
	}

	public void setVres(int value, String label) {
		this.vres = new Vres(value, label);
	}

	public Sessions getSessions() {
		return sessions;
	}

	public void setSessions(int value, String label) {
		this.sessions = new Sessions(value, label);
	}

	@Override
	public String toString() {
		return "Statistics {" + "users=" + users + ", countries=" + countries + ", operations=" + operations + ", vres="
				+ vres + ", sessions=" + sessions + '}';
	}

	// Inner class for Users
	public static class Users {
		public int value;
		public String label;

		public Users(int value, String label) {
			this.value = value;
			this.label = label;
		}

		@Override
		public String toString() {
			return "Users {value=" + value + ", label='" + label + "'}";
		}
	}

	// Inner class for Countries
	public static class Countries {
		public int value;
		public String label;

		public Countries(int value, String label) {
			this.value = value;
			this.label = label;
		}

		@Override
		public String toString() {
			return "Countries {value=" + value + ", label='" + label + "'}";
		}
	}

	// Inner class for Operations
	public static class Operations {
		public int value;
		public String label;

		public Operations(int value, String label) {
			this.value = value;
			this.label = label;
		}

		@Override
		public String toString() {
			return "Operations {value=" + value + ", label='" + label + "'}";
		}
	}

	// Inner class for Vres
	public static class Vres {
		public int value;
		public String label;

		public Vres(int value, String label) {
			this.value = value;
			this.label = label;
		}

		@Override
		public String toString() {
			return "Vres {value=" + value + ", label='" + label + "'}";
		}
	}

	// Inner class for Sessions
	public static class Sessions {
		public int value;
		public String label;

		public Sessions(int value, String label) {
			this.value = value;
			this.label = label;
		}

		@Override
		public String toString() {
			return "Sessions {value=" + value + ", label='" + label + "'}";
		}
	}
}
