package org.gcube.portal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.portal.GCubePortalConstants;
import org.gcube.portal.shared.UserBelonging;
import org.gcube.portal.shared.VRE;
import org.gcube.portal.shared.VRECategory;
import org.gcube.portal.shared.VreMembershipType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

@SuppressWarnings("serial")
public class GatewayVresInfoService extends HttpServlet {

	private static final Logger _log = LoggerFactory.getLogger(GatewayVresInfoService.class);

	public static final String PREFIX_PUBLIC_URL = "/web";
	public static final String PREFIX_PRIVATE_URL = "/group";
	public static final String GET_OID_PARAMETER = "siteId";
	public static final String KEYWORDS_CUSTOM_FIELD = "Keywords";
	public static final String COMMUNITY_CUSTOM_FIELD = "Communities";

	public void init() {

	}

	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String toReturn = "";
		System.out.println("doGet GatewayVresInfoService");
		try {
			StringBuffer url = request.getRequestURL();
			String uri = request.getRequestURI();
			String host = url.substring(0, url.indexOf(uri)); // result

			List<Gateway> gateways = getGateways(new LiferayGroupManager(), host);
			for (Gateway gateway : gateways) {
				_log.debug("found gateway: " + gateway.getName());
				LinkedHashMap<VRECategory, ArrayList<VRE>> hashMap = getPortalSitesMappedToVRE(gateway.getSiteGroupId(),
						host);
				gateway.setVreListMap(hashMap);
				int totalUsers = 0;
				for (VRECategory cat : hashMap.keySet()) {
					_log.debug("category: " + cat.getName() + ":" + cat.getDescription());
					for (VRE vre : hashMap.get(cat)) {
						int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount(vre.getId());
						_log.debug("VRE: " + vre.getName() + " has #users=)" + vreSiteUsersNo);
						totalUsers += vreSiteUsersNo;
					}
				}
				gateway.setUsersNo(totalUsers);
			}
			ObjectMapper om = new ObjectMapper();
			// covert Java object to JSON strings
			toReturn = om.writeValueAsString(gateways);

		} catch (Exception e) {
			e.printStackTrace();
			toReturn = "<DIV>An error occurred: " + e.getMessage() + "</DIV>";
		}

		PrintWriter out = response.getWriter();
		response.setContentType("application/json");
		response.setCharacterEncoding("UTF-8");
		out.print(toReturn);
		out.flush();
	}

	public List<Gateway> getGateways(GroupManager groupsManager, String host) {
		List<Gateway> toReturn = new ArrayList<>();
		try {
			List<Group> candidateGateways = GroupLocalServiceUtil.getGroups(ManagementUtils.getCompany().getCompanyId(),
					0, true);
			// needed to access custom Site attributes
			long userId = LiferayUserManager.getAdmin().getUserId();
			PrincipalThreadLocal.setName(userId);
			PermissionChecker permissionChecker = PermissionCheckerFactoryUtil
					.create(UserLocalServiceUtil.getUser(userId));
			PermissionThreadLocal.setPermissionChecker(permissionChecker);

			// real gateways have no children as well
			for (Group group : candidateGateways) {
				List<Group> children = group.getChildren(true);
				if (children == null || children.isEmpty())
					if (!(group.getFriendlyURL().equals("/guest") || group.getFriendlyURL().equals("/global")
							|| group.getFriendlyURL().equals("/data-e-infrastructure-gateway")
							|| group.getFriendlyURL().equals("/d4science-developers"))) {// skipping these sites
						GCubeGroup gatewayGroup = groupsManager.getGroup(group.getGroupId());
						String gatewayDescription = gatewayGroup.getDescription();
						gatewayDescription = Jsoup.parse(gatewayDescription).text(); // Clean HTML tags
						long logoId = gatewayGroup.getLogoId();
						String gatewayLogoURL = host + groupsManager.getGroupLogoURL(logoId);

						String keywords = (String) group.getExpandoBridge().getAttribute(KEYWORDS_CUSTOM_FIELD);
						String communities = (String) group.getExpandoBridge().getAttribute(COMMUNITY_CUSTOM_FIELD);
						Gateway toAdd = new Gateway(group.getName(), gatewayDescription, keywords, communities,
								gatewayLogoURL, group.getGroupId(), getGatewayURL(group));
						toReturn.add(toAdd);
					}
			}
		} catch (Exception e) {
			_log.error("Failed to retrieve the list of gateways", e);
			return null;
		}
		return toReturn;
	}

	private String getGatewayURL(Group gateway) throws PortalException, SystemException {

		LayoutSet layoutSet = null;
		if (gateway.hasPublicLayouts())
			layoutSet = gateway.getPublicLayoutSet();
		else
			layoutSet = gateway.getPrivateLayoutSet();
		final long companyId = PortalUtil.getDefaultCompanyId();
		long layoutSetId = layoutSet.getLayoutSetId();
		String vHost = "";
		try {
			vHost = VirtualHostLocalServiceUtil.getVirtualHost(companyId, layoutSetId).getHostname();
		} catch (PortalException | SystemException e) {
			e.printStackTrace();
		}
		String theURL = "https://" + vHost;
		return theURL;
	}

//	private String getGatewaySiteLandinPage(long groupid) throws PortalException, SystemException {
//		Group gateway = GroupLocalServiceUtil.getGroup(groupid);
//		LayoutSet layoutSet = null;			
//
//		layoutSet = gateway.getPrivateLayoutSet().getTheme().get;
//		final long companyId = PortalUtil.getDefaultCompanyId();
//		long layoutSetId = layoutSet.getLayoutSetId();
//		String vHost = "";
//		try {
//			vHost = VirtualHostLocalServiceUtil.getVirtualHost(companyId, layoutSetId).getHostname();
//		} catch (PortalException | SystemException e) {
//			e.printStackTrace();
//		}
//		String theURL = "https://"+vHost;
//		return theURL;
//	}
	/**
	 * 
	 * @return the Virtual groups with their VREs in the order established in the LR
	 *         Control Panel
	 * @throws SystemException
	 * @throws PortalException
	 */
	public LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE(long gatewaySiteGroupId, String host)
			throws Exception {
		LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();

		long currentSiteGroupId = gatewaySiteGroupId;

		Group gateway = GroupLocalServiceUtil.getGroup(currentSiteGroupId);
		String gatewayURL = getGatewayURL(gateway); // "https://"+vHost;

		GroupManager groupsManager = new LiferayGroupManager();
		List<VirtualGroup> currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);

		for (VirtualGroup vg : currentSiteVGroups) {
			ArrayList<VRE> toCreate = new ArrayList<VRE>();
			VRECategory cat = new VRECategory(1L, vg.getName(), vg.getDescription());
			toReturn.put(cat, toCreate);
		}

		GCubeGroup rootGroupVO = groupsManager.getRootVO();

		try {
			_log.debug("root: " + rootGroupVO.getGroupName());
		} catch (NullPointerException e) {
			_log.error(
					"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
			return toReturn;
		}
		long userId = LiferayUserManager.getAdmin().getUserId();
		PrincipalThreadLocal.setName(userId);
		PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(UserLocalServiceUtil.getUser(userId));
		PermissionThreadLocal.setPermissionChecker(permissionChecker);

		_log.debug("for each root sub organizations (VO): ");
		// for each root sub organizations (VO)
		for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
			_log.debug("vOrg: " + vOrg.getGroupName());
			for (GCubeGroup vreSite : vOrg.getChildren()) {
				long vreID = vreSite.getGroupId();
				String vreName = vreSite.getGroupName();
				String vreDescription = vreSite.getDescription();
				vreDescription = Jsoup.parse(vreDescription).text(); // Clean HTML tags
				long logoId = vreSite.getLogoId();
				String vreLogoURL = host + groupsManager.getGroupLogoURL(logoId);
				String groupName = groupsManager.getInfrastructureScope(vreSite.getGroupId());
				String friendlyURL = GCubePortalConstants.PREFIX_GROUP_URL + vreSite.getFriendlyURL();

				String keywords = (String) groupsManager.readCustomAttr(vreID, KEYWORDS_CUSTOM_FIELD);
				// _log.debug("vreName: " + vreName);

				List<VirtualGroup> vreGroups = groupsManager.getVirtualGroups(vreID);
				for (VirtualGroup vreGroup : vreGroups) {
					for (VRECategory vreCat : toReturn.keySet()) {
						if (vreCat.getName().compareTo(vreGroup.getName()) == 0) {
							ArrayList<VRE> toUpdate = toReturn.get(vreCat);
							UserBelonging belongs = UserBelonging.NOT_BELONGING;
							int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount(vreSite.getGroupId());

							String joinVRErequestURL = "";
							if (vreSite.getMembershipType() != GroupMembershipType.PRIVATE) {
								joinVRErequestURL = new StringBuilder().append(gatewayURL).append(PREFIX_PRIVATE_URL)
										.append(gateway.getFriendlyURL()).append("/explore?")
										.append(GatewayVresInfoService.GET_OID_PARAMETER).append("=").append(vreID)
										.toString();
							}

							VRE toAdd = new VRE(vreID, vreName, vreDescription, keywords, vreCat.getName(), vreLogoURL,
									groupName, friendlyURL, belongs, getVREMembershipType(vreSite.getMembershipType()),
									vreSiteUsersNo, joinVRErequestURL);
							if (GroupLocalServiceUtil.getGroup(vreID).getPublicLayoutsPageCount() > 0) {
								String publicURL = gatewayURL + PREFIX_PUBLIC_URL + vreSite.getFriendlyURL();
								toAdd.setPublicURL(publicURL);
							}
							toUpdate.add(toAdd);
						}
					}
				}
			}
		}

		// sort the vres in the groups
		for (VRECategory cat : toReturn.keySet()) {
			ArrayList<VRE> toSort = toReturn.get(cat);
			Collections.sort(toSort);
		}
		return toReturn;
	}

	/**
	 * 
	 * @param type
	 * @return the correspondent mapping to the gcube model
	 */
	private VreMembershipType getVREMembershipType(GroupMembershipType type) {
		switch (type) {
		case RESTRICTED:
			return VreMembershipType.RESTRICTED;
		case OPEN:
			return VreMembershipType.OPEN;
		default:
			return VreMembershipType.PRIVATE;
		}
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
	}

}