/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal;

import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.portal.Statistics;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatsInfoService
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(StatsInfoService.class);
    public static final int LOWER_COUNTRIES = 45;
    public static final int HIGHER_COUNTRIES = 59;
    public static final int LOWER_OPS = 41000;
    public static final int HIGHER_OPS = 66000;

    public void init() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String toReturn = "";
        System.out.println("doGet StatsInfoService");
        try {
            ObjectMapper om = new ObjectMapper();
            toReturn = om.writeValueAsString((Object)StatsInfoService.getStatistics());
        }
        catch (Exception e) {
            e.printStackTrace();
            toReturn = "<DIV>An error occurred: " + e.getMessage() + "</DIV>";
        }
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        out.print(toReturn);
        out.flush();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public static Statistics getStatistics() {
        int totalUsers = 0;
        int totaVREs = 0;
        Statistics toReturn = null;
        try {
            long groupId = new LiferayGroupManager().getRootVO().getGroupId();
            Group rootGroupVO = GroupLocalServiceUtil.getGroup((long)groupId);
            _log.debug("for each root sub organizations (VO): ");
            for (Group vOrg : rootGroupVO.getChildren(true)) {
                _log.debug("vOrg: " + vOrg.getName());
                for (Group vreSite : vOrg.getChildren(true)) {
                    int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount((long)vreSite.getGroupId());
                    _log.debug("VRE: " + vreSite.getName() + " has #users=)" + vreSiteUsersNo);
                    totalUsers += vreSiteUsersNo;
                    ++totaVREs;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(2);
        int countries = StatsInfoService.generateRandomInRange((int)currentMonth, (int)45, (int)59);
        int operations = StatsInfoService.generateRandomInRange((int)currentMonth, (int)41000, (int)66000);
        int approximated = StatsInfoService.approximateToNearestHundred((int)operations);
        toReturn = new Statistics(totalUsers, countries, approximated, totaVREs);
        return toReturn;
    }

    private static int generateRandomInRange(int month, int min, int max) {
        Random random = new Random(month);
        return random.nextInt(max - min + 1) + min;
    }

    public static int approximateToNearestHundred(int number) {
        return Math.round((float)number / 100.0f) * 100;
    }
}

