/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.portal.Gateway;
import org.gcube.portal.GatewayVresInfoService;
import org.gcube.portal.shared.UserBelonging;
import org.gcube.portal.shared.VRE;
import org.gcube.portal.shared.VRECategory;
import org.gcube.portal.shared.VreMembershipType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayVresInfoService
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(GatewayVresInfoService.class);
    public static final String PREFIX_PUBLIC_URL = "/web";
    public static final String PREFIX_PRIVATE_URL = "/group";
    public static final String GET_OID_PARAMETER = "siteId";
    public static final String KEYWORDS_CUSTOM_FIELD = "Keywords";
    public static final String COMMUNITY_CUSTOM_FIELD = "Communities";

    public void init() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String toReturn = "";
        System.out.println("doGet GatewayVresInfoService");
        try {
            StringBuffer url = request.getRequestURL();
            String uri = request.getRequestURI();
            String host = url.substring(0, url.indexOf(uri));
            List gateways = this.getGateways((GroupManager)new LiferayGroupManager(), host);
            for (Gateway gateway : gateways) {
                _log.debug("found gateway: " + gateway.getName());
                LinkedHashMap hashMap = this.getPortalSitesMappedToVRE(gateway.getSiteGroupId(), host);
                gateway.setVreListMap(hashMap);
                int totalUsers = 0;
                for (VRECategory cat : hashMap.keySet()) {
                    _log.debug("category: " + cat.getName() + ":" + cat.getDescription());
                    for (VRE vre : (ArrayList)hashMap.get(cat)) {
                        int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount((long)vre.getId());
                        _log.debug("VRE: " + vre.getName() + " has #users=)" + vreSiteUsersNo);
                        totalUsers += vreSiteUsersNo;
                    }
                }
                gateway.setUsersNo(totalUsers);
            }
            ObjectMapper om = new ObjectMapper();
            toReturn = om.writeValueAsString((Object)gateways);
        }
        catch (Exception e) {
            e.printStackTrace();
            toReturn = "<DIV>An error occurred: " + e.getMessage() + "</DIV>";
        }
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        out.print(toReturn);
        out.flush();
    }

    public List<Gateway> getGateways(GroupManager groupsManager, String host) {
        ArrayList<Gateway> toReturn = new ArrayList<Gateway>();
        try {
            List candidateGateways = GroupLocalServiceUtil.getGroups((long)ManagementUtils.getCompany().getCompanyId(), (long)0L, (boolean)true);
            long userId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            for (Group group : candidateGateways) {
                List children = group.getChildren(true);
                if (children != null && !children.isEmpty() || group.getFriendlyURL().equals("/guest") || group.getFriendlyURL().equals("/global") || group.getFriendlyURL().equals("/data-e-infrastructure-gateway") || group.getFriendlyURL().equals("/d4science-developers")) continue;
                GCubeGroup gatewayGroup = groupsManager.getGroup(group.getGroupId());
                String gatewayDescription = gatewayGroup.getDescription();
                gatewayDescription = Jsoup.parse((String)gatewayDescription).text();
                long logoId = gatewayGroup.getLogoId();
                String gatewayLogoURL = host + groupsManager.getGroupLogoURL(logoId);
                String keywords = (String)((Object)group.getExpandoBridge().getAttribute(KEYWORDS_CUSTOM_FIELD));
                String communities = (String)((Object)group.getExpandoBridge().getAttribute(COMMUNITY_CUSTOM_FIELD));
                Gateway toAdd = new Gateway(group.getName(), gatewayDescription, keywords, communities, gatewayLogoURL, group.getGroupId(), this.getGatewayURL(group));
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            _log.error("Failed to retrieve the list of gateways", (Throwable)e);
            return null;
        }
        return toReturn;
    }

    private String getGatewayURL(Group gateway) throws PortalException, SystemException {
        LayoutSet layoutSet = null;
        layoutSet = gateway.hasPublicLayouts() ? gateway.getPublicLayoutSet() : gateway.getPrivateLayoutSet();
        long companyId = PortalUtil.getDefaultCompanyId();
        long layoutSetId = layoutSet.getLayoutSetId();
        String vHost = "";
        try {
            vHost = VirtualHostLocalServiceUtil.getVirtualHost((long)companyId, (long)layoutSetId).getHostname();
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        String theURL = "https://" + vHost;
        return theURL;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE(long gatewaySiteGroupId, String host) throws Exception {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        long currentSiteGroupId = gatewaySiteGroupId;
        Group gateway = GroupLocalServiceUtil.getGroup((long)currentSiteGroupId);
        String gatewayURL = this.getGatewayURL(gateway);
        LiferayGroupManager groupsManager = new LiferayGroupManager();
        List currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);
        for (VirtualGroup vg : currentSiteVGroups) {
            ArrayList toCreate = new ArrayList();
            VRECategory cat = new VRECategory(1L, vg.getName(), vg.getDescription());
            toReturn.put(cat, toCreate);
        }
        GCubeGroup rootGroupVO = groupsManager.getRootVO();
        try {
            _log.debug("root: " + rootGroupVO.getGroupName());
        }
        catch (NullPointerException e) {
            _log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return toReturn;
        }
        long userId = LiferayUserManager.getAdmin().getUserId();
        PrincipalThreadLocal.setName((long)userId);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        _log.debug("for each root sub organizations (VO): ");
        for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
            _log.debug("vOrg: " + vOrg.getGroupName());
            for (GCubeGroup vreSite : vOrg.getChildren()) {
                long vreID = vreSite.getGroupId();
                String vreName = vreSite.getGroupName();
                String vreDescription = vreSite.getDescription();
                vreDescription = Jsoup.parse((String)vreDescription).text();
                long logoId = vreSite.getLogoId();
                String vreLogoURL = host + groupsManager.getGroupLogoURL(logoId);
                String groupName = groupsManager.getInfrastructureScope(vreSite.getGroupId());
                String friendlyURL = PREFIX_PRIVATE_URL + vreSite.getFriendlyURL();
                String keywords = (String)((Object)groupsManager.readCustomAttr(vreID, KEYWORDS_CUSTOM_FIELD));
                List vreGroups = groupsManager.getVirtualGroups(vreID);
                for (VirtualGroup vreGroup : vreGroups) {
                    for (VRECategory vreCat : toReturn.keySet()) {
                        if (vreCat.getName().compareTo(vreGroup.getName()) != 0) continue;
                        ArrayList<VRE> toUpdate = toReturn.get(vreCat);
                        UserBelonging belongs = UserBelonging.NOT_BELONGING;
                        int vreSiteUsersNo = UserLocalServiceUtil.getGroupUsersCount((long)vreSite.getGroupId());
                        String joinVRErequestURL = "";
                        if (vreSite.getMembershipType() != GroupMembershipType.PRIVATE) {
                            joinVRErequestURL = gatewayURL + PREFIX_PRIVATE_URL + gateway.getFriendlyURL() + "/explore?" + GET_OID_PARAMETER + "=" + vreID;
                        }
                        VRE toAdd = new VRE(vreID, vreName, vreDescription, keywords, vreCat.getName(), vreLogoURL, groupName, friendlyURL, belongs, this.getVREMembershipType(vreSite.getMembershipType()), vreSiteUsersNo, joinVRErequestURL);
                        if (GroupLocalServiceUtil.getGroup((long)vreID).getPublicLayoutsPageCount() > 0) {
                            String publicURL = gatewayURL + PREFIX_PUBLIC_URL + vreSite.getFriendlyURL();
                            toAdd.setPublicURL(publicURL);
                        }
                        toUpdate.add(toAdd);
                    }
                }
            }
        }
        for (VRECategory cat : toReturn.keySet()) {
            ArrayList<VRE> toSort = toReturn.get(cat);
            Collections.sort(toSort);
        }
        return toReturn;
    }

    private VreMembershipType getVREMembershipType(GroupMembershipType type) {
        switch (1.$SwitchMap$org$gcube$vomanagement$usermanagement$model$GroupMembershipType[type.ordinal()]) {
            case 1: {
                return VreMembershipType.RESTRICTED;
            }
            case 2: {
                return VreMembershipType.OPEN;
            }
        }
        return VreMembershipType.PRIVATE;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

