package org.gcube.portal.event.publisher.lr62;

import org.gcube.event.publisher.AbstractEventPublisher;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.HTTPWithUMAAuthEventSender;
import org.gcube.oidc.rest.OpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

public abstract class AbstractLR62EventPublisher extends AbstractEventPublisher {

    protected static final Log log = LogFactoryUtil.getLog(AbstractLR62EventPublisher.class);

    protected static final boolean PUBLISH_ON_SYSOUT = false;

    public AbstractLR62EventPublisher() {
        super();
    }

    protected EventSender createEventSender() {
        if (PUBLISH_ON_SYSOUT) {
            return new EventSender() {
                @Override
                public void send(Event event) {
                    System.out.println(event);
                }
            };
        } else {
            OpenIdConnectConfiguration openIdConnectConfiguration = LiferayOpenIdConnectConfiguration
                    .getConfiguration();

            EventPublisherConfiguration eventPublisherConfiguration = EventPublisherConfiguration.getConfiguration();
            // Here the access_token use should be sufficient, but we send the UMA token for future implementation
            // were more fine grained permissions will be needed
            return new HTTPWithUMAAuthEventSender(eventPublisherConfiguration.getEventPublisherURL(),
                    openIdConnectConfiguration.getPortalClientId(), openIdConnectConfiguration.getPortalClientSecret(),
                    openIdConnectConfiguration.getTokenURL(), openIdConnectConfiguration.getPortalClientId());
        }
    }

}