/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.gcube.event.publisher.Event;
import org.gcube.portal.event.publisher.lr62.EventPublisherConfiguration;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

public class PortalEvent
extends Event {
    private static final long serialVersionUID = -6940345709578482873L;
    protected static final Log log = LogFactoryUtil.getLog(PortalEvent.class);
    protected static final UserManager USER_MANAGER = new LiferayUserManager();
    protected static final GroupManager GROUP_MANAGER = new LiferayGroupManager();
    protected static final RoleManager ROLE_MANAGER = new LiferayRoleManager();
    public static final String TYPE = "portal";
    public static final String USER_ENTRY = "user";
    public static final String GROUP_ENTRY = "group";
    public static final String ROLE_ENTRY = "role";

    public PortalEvent(String name) {
        this(name, null);
    }

    public PortalEvent(String name, Map<String, String> data) {
        super(name, TYPE, EventPublisherConfiguration.getConfiguration().getRootVOName(), data);
    }

    public void setUser(User user) {
        this.setUser(this.getUserIdentifier(user));
    }

    protected String getUserIdentifier(User user) {
        return user.getScreenName();
    }

    public void setUser(String user) {
        this.set(USER_ENTRY, user);
    }

    public String getUser() {
        return (String)this.get(USER_ENTRY);
    }

    public void setGroup(String group) {
        this.set(GROUP_ENTRY, group);
    }

    public String getGroup() {
        return (String)this.get(GROUP_ENTRY);
    }

    public void setGroup(Group group) {
        this.setGroup(this.getGroupIdentifier(group));
    }

    protected String getGroupIdentifier(Group group) {
        try {
            return URLEncoder.encode(GROUP_MANAGER.getInfrastructureScope(group.getGroupId()), "UTF-8");
        }
        catch (UnsupportedEncodingException | GroupRetrievalFault | UserManagementSystemException e) {
            log.warn((Object)("Cannot get URL encoded infrastrucure scope for group: " + group), e);
            return null;
        }
    }

    public void setRole(String role) {
        this.set(ROLE_ENTRY, role);
    }

    public String getRole() {
        return (String)this.get(ROLE_ENTRY);
    }

    public void setRole(Role role) throws PortalException, SystemException {
        this.setRole(this.getRoleIdentifier(role));
    }

    protected String getRoleIdentifier(Role role) throws PortalException, SystemException {
        try {
            return ROLE_MANAGER.getRole(role.getRoleId()).getRoleName();
        }
        catch (RoleRetrievalFault | UserManagementSystemException e) {
            log.error((Object)("Cannot get gCube role for role: " + role), e);
            return null;
        }
    }
}

