/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.util.Map;
import org.gcube.event.publisher.Event;
import org.gcube.portal.event.publisher.lr62.EventPublisherConfiguration;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

public class PortalEvent
extends Event {
    private static final long serialVersionUID = -6940345709578482873L;
    protected static final Log log = LogFactoryUtil.getLog(PortalEvent.class);
    protected static final UserManager USER_MANAGER = new LiferayUserManager();
    public static final String TYPE = "portal";
    public static final String USER_ENTRY = "user";
    public static final String GROUP_ENTRY = "group";
    public static final String ROLE_ENTRY = "role";

    public PortalEvent(String name) {
        this(name, null);
    }

    public PortalEvent(String name, Map<String, String> data) {
        super(name, TYPE, EventPublisherConfiguration.getConfiguration().getRootVOName(), data);
    }

    public void setUser(User user) throws UserManagementSystemException, UserRetrievalFault {
        this.setUser(this.getUserIdentifier(user));
    }

    protected String getUserIdentifier(User user) throws UserManagementSystemException, UserRetrievalFault {
        return USER_MANAGER.getUserById(user.getUserId()).getUsername();
    }

    public void setUser(String user) {
        this.set(USER_ENTRY, user);
    }

    public String getUser() {
        return (String)this.get((Object)USER_ENTRY);
    }

    public void setGroup(String group) {
        this.set(GROUP_ENTRY, group);
    }

    public String getGroup() {
        return (String)this.get((Object)GROUP_ENTRY);
    }

    public void setRole(String role) {
        this.set(ROLE_ENTRY, role);
    }

    public String getRole() {
        return (String)this.get((Object)ROLE_ENTRY);
    }
}

