/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.util.PortalUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventPublisherConfiguration {
    protected static final Log log = LogFactoryUtil.getLog(EventPublisherConfiguration.class);
    public static Map<Long, EventPublisherConfiguration> companyId2Configuration = Collections.synchronizedMap(new HashMap());
    private Long companyId;
    private URL eventPublisherURL;
    private String rootVOName;
    private String encodedRootVOContext;

    public static synchronized EventPublisherConfiguration getConfiguration(Long companyId) {
        log.trace((Object)"Getting config from companyId");
        if (!companyId2Configuration.containsKey(companyId)) {
            companyId2Configuration.put(companyId, new EventPublisherConfiguration(companyId));
        }
        return (EventPublisherConfiguration)companyId2Configuration.get(companyId);
    }

    public static synchronized EventPublisherConfiguration getConfiguration(HttpServletRequest request) {
        log.trace((Object)"Getting config from request");
        return EventPublisherConfiguration.getConfiguration((Long)PortalUtil.getCompanyId((HttpServletRequest)request));
    }

    public static synchronized EventPublisherConfiguration getConfiguration() {
        log.trace((Object)"Getting config from thread local");
        return EventPublisherConfiguration.getConfiguration((Long)CompanyThreadLocal.getCompanyId());
    }

    private EventPublisherConfiguration(Long companyId) {
        log.info((Object)("Creating config from companyId: " + companyId));
        this.companyId = companyId;
        try {
            this.eventPublisherURL = new URL(PrefsPropsUtil.getString((long)companyId, (String)"d4science.event-broker-endpoint"));
        }
        catch (SystemException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
        log.info((Object)("eventPublisherURL=" + this.getEventPublisherURL()));
        try {
            this.rootVOName = new LiferayGroupManager().getRootVOName();
            this.encodedRootVOContext = URLEncoder.encode("/" + this.rootVOName, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)"Cannot compute encoded root VO context", (Throwable)e);
        }
    }

    public Long getCompanyId() {
        return this.companyId;
    }

    public URL getEventPublisherURL() {
        return this.eventPublisherURL;
    }

    public String getRootVOName() {
        return this.rootVOName;
    }

    public String getEncodedRootVOContext() {
        return this.encodedRootVOContext;
    }
}

