package org.gcube.portal.event.publisher.lr62.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

import org.gcube.portal.event.publisher.lr62.PortalEvent;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;

public class PortalModelListenerEvent<T extends BaseModel<T>> extends PortalEvent {

    private static final long serialVersionUID = -9062395669075373612L;

    public static final String MODELCLASSNAME_ENTRY = "model-class-name";

    protected static final GroupManager GROUP_MANAGER = new LiferayGroupManager();
    protected static final RoleManager ROLE_MANAGER = new LiferayRoleManager();

    public PortalModelListenerEvent(String name, T baseModel) {
        super(name);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, User user, T baseModel)
            throws UserManagementSystemException, UserRetrievalFault {

        super(name);
        setUser(user);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, Map<String, String> data, User user, T baseModel)
            throws UserManagementSystemException, UserRetrievalFault {

        super(name, data);
        setUser(user);
        setModelClassName(baseModel.getModelClassName());
    }

    public void setGroup(Group group) throws PortalException, SystemException {
        setGroup(getGroupIdentifier(group));
    }

    protected String getGroupIdentifier(Group group) throws PortalException, SystemException {
        try {
            return URLEncoder.encode(GROUP_MANAGER.getInfrastructureScope(group.getGroupId()), "UTF-8");
        } catch (UnsupportedEncodingException | UserManagementSystemException | GroupRetrievalFault e) {
            log.error("Cannot get URL encoded infrastrucure scope for group: " + group, e);
            return null;
        }
    }

    public void setRole(Role role) throws PortalException, SystemException {
        setRole(getRoleIdentifier(role));
    }

    protected String getRoleIdentifier(Role role) throws PortalException, SystemException {
        try {
            return ROLE_MANAGER.getRole(role.getRoleId()).getRoleName();
        } catch (UserManagementSystemException | RoleRetrievalFault e) {
            log.error("Cannot get gCube role for role: " + role, e);
            return null;
        }
    }

    public void setModelClassName(String group) {
        set(MODELCLASSNAME_ENTRY, group);
    }

    public String getModelClassName() {
        return (String) get(MODELCLASSNAME_ENTRY);
    }

}
