package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.UserGroupRole;

public class UserGroupRoleEventPublisher extends AbstractEventPublisherBaseModelListener<UserGroupRole> {

    @Override
    public void onAfterCreate(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Group group = userGroupRole.getGroup();
            if (group.isSite()) {
                log.info("Created a site user's group role");
                UserGroupRoleEvent event = UserGroupRoleEvent.newCreatedEvent(userGroupRole, userGroupRole.getUser(),
                        group,
                        userGroupRole.getRole());

                if (log.isDebugEnabled()) {
                    log.debug("Event is: " + event);
                }
                publish(event);
            } else {
                log.info("Created a non-site user's group role");
            }
        } catch (PortalException | SystemException e) {
            log.error("Cannot get related model objects", e);
        }

    }

    @Override
    public void onBeforeRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        try {
            Group group = userGroupRole.getGroup();
            if (group.isSite()) {
                log.info("Deleted a site user's group role");
                publish(UserGroupRoleEvent.newDeletedEvent(userGroupRole, userGroupRole.getUser(), group,
                        userGroupRole.getRole()));
            } else {
                log.info("Deleted a non-site user's group role");
            }
        } catch (PortalException | SystemException e) {
            log.error("Cannot get related model objects", e);
        }
    }

    /* Uninteresting model events */

    @Override
    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAfterRemove(UserGroupRole userGroupRole) throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAfterUpdate(UserGroupRole userGroupRole) throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onBeforeCreate(UserGroupRole userGroupRole) throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
        // TODO Auto-generated method stub

    }

    @Override
    public void onBeforeUpdate(UserGroupRole userGroupRole) throws ModelListenerException {
        // TODO Auto-generated method stub

    }

}
