package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.User;

public class UserEventPublisher extends AbstractEventPublisherBaseModelListener<User> {

    @Override
    public void onAfterCreate(User user) throws ModelListenerException {
        log.info("New user created");
        UserEvent userEvent = UserEvent.newCreatedEvent(user);
        if (log.isDebugEnabled()) {
            log.debug("User event is: " + userEvent);
        }
        publish(userEvent);
    }

    @Override
    public void onBeforeRemove(User user) throws ModelListenerException {
        log.info("User removed");
        UserEvent userEvent = UserEvent.newDeletedEvent(user);
        if (log.isDebugEnabled()) {
            log.debug("User event is: " + userEvent);
        }
        publish(userEvent);
    }

    /* Uninteresting model events */

    @Override
    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onAfterRemove(User user) throws ModelListenerException {
    }

    @Override
    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onAfterUpdate(User user) throws ModelListenerException {
    }

    @Override
    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onBeforeCreate(User user) throws ModelListenerException {
    }

    @Override
    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onBeforeUpdate(User user) throws ModelListenerException {
    }

}
