package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.model.User;

public class UserEvent extends PortalModelListenerEvent<User> {

    private static final long serialVersionUID = 3939268094440017646L;

    public static final String CREATED_NAME = "user_created";
    public static final String DELETED_NAME = "user_deleted";

    private UserEvent(String name, User user) {
        super(name, user, user);
    }

    public static UserEvent newCreatedEvent(User user) {
        return new UserEvent(CREATED_NAME, user);
    }

    public static UserEvent newDeletedEvent(User user) {
        return new UserEvent(DELETED_NAME, user);
    }

}
