package org.gcube.portal.event.publisher.lr62;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

import org.gcube.event.publisher.Event;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class PortalEvent extends Event {

    private static final long serialVersionUID = -6940345709578482873L;

    protected static final Log log = LogFactoryUtil.getLog(PortalEvent.class);

    protected static final UserManager USER_MANAGER = new LiferayUserManager();

    private static String rootVOName;

    public static final String TYPE = "portal";
    public static final String GROUP_ENTRY = "group";
    public static final String ROLE_ENTRY = "role";

    static {
        try {
            rootVOName = new LiferayGroupManager().getRootVOName();
        } catch (Exception e) {
            log.warn("Cannot get root VO name, using hostname");
            try {
                rootVOName = InetAddress.getLocalHost().getHostName();
            } catch (UnknownHostException e1) {
                log.error("Cannot get localhost name", e);
                rootVOName = PortalUtil.getComputerName();
            }
        }
    }

    public PortalEvent(String name) {
        super(name, TYPE, getRootVOName());
    }

    public PortalEvent(String name, User user) {
        this(name, getUserIdentifier(user));
    }

    public PortalEvent(String name, String user) {
        super(name, TYPE, getRootVOName(), user);
    }

    public PortalEvent(String name, User user, Map<String, String> data) {
        this(name, getUserIdentifier(user), data);
    }

    public PortalEvent(String name, String user, Map<String, String> data) {
        super(name, TYPE, getRootVOName(), user, data);
    }

    protected static String getRootVOName() {
        return rootVOName;
    }

    public void setUser(User user) {
        setUser(getUserIdentifier(user));
    }

    protected static String getUserIdentifier(User user) {
        try {
            return USER_MANAGER.getUserById(user.getUserId()).getUsername();
        } catch (UserManagementSystemException | UserRetrievalFault e) {
            log.error("Cannot get username for user: " + user, e);
            return null;
        }
    }

    public void setGroup(String group) {
        set(GROUP_ENTRY, group);
    }

    public String getGroup() {
        return (String) (GROUP_ENTRY);
    }

    public void setRole(String role) {
        set(ROLE_ENTRY, role);
    }

    public String getRole() {
        return (String) (ROLE_ENTRY);
    }

}