package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.User;

public class UserEventPublisher extends AbstractEventPublisherBaseModelListener<User> {

    @Override
    public void onAfterCreate(User user) throws ModelListenerException {
        publish(UserEvent.newCreatedEvent(user));
    }

    @Override
    public void onBeforeRemove(User user) throws ModelListenerException {
        publish(UserEvent.newDeletedEvent(user));
    }

    /* Uninteresting model events */

    @Override
    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onAfterRemove(User user) throws ModelListenerException {
    }

    @Override
    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onAfterUpdate(User user) throws ModelListenerException {
    }

    @Override
    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onBeforeCreate(User user) throws ModelListenerException {
    }

    @Override
    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK)
            throws ModelListenerException {
    }

    @Override
    public void onBeforeUpdate(User user) throws ModelListenerException {
    }

}
