package org.gcube.portal.event.publisher.lr62.model;

import java.util.Map;

import org.gcube.portal.event.publisher.lr62.PortalEvent;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;

public class PortalModelListenerEvent<T extends BaseModel<T>> extends PortalEvent {

    private static final long serialVersionUID = -9062395669075373612L;

    public static final String MODELCLASSNAME_ENTRY = "model-class-name";

    public PortalModelListenerEvent(String name, T baseModel) {
        super(name);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, User user, T baseModel) {
        super(name, user);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, String user, T baseModel) {
        super(name, user);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, String user, Map<String, String> data, T baseModel) {
        super(name, user, data);
        setModelClassName(baseModel.getModelClassName());
    }

    public PortalModelListenerEvent(String name, User user, Map<String, String> data, T baseModel) {
        super(name, user, data);
        setModelClassName(baseModel.getModelClassName());
    }

    public void setGroup(Group group) throws PortalException, SystemException {
        setGroup(getGroupIdentifier(group));
    }

    protected static String getGroupIdentifier(Group group) throws PortalException, SystemException {
        return group.getDescriptiveName();
    }

    public void setRole(Role role) throws PortalException, SystemException {
        setRole(getRoleIdentifier(role));
    }

    protected static String getRoleIdentifier(Role role) throws PortalException, SystemException {
        return role.getDescriptiveName();
    }

    public void setModelClassName(String group) {
        set(MODELCLASSNAME_ENTRY, group);
    }

    public String getModelClassName() {
        return (String) (MODELCLASSNAME_ENTRY);
    }

}
