package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;

public class RoleEvent extends PortalModelListenerEvent<Role> {

    private static final long serialVersionUID = 3939268094440017646L;

    public static final String CREATED_NAME = "Role_created";
    public static final String DELETED_NAME = "Role_deleted";
    public static final String UPDATED_NAME = "Role_updated";

    public static final String OLD_ROLE_ENTRY = "old-role";

    private RoleEvent(String name, Role role) throws PortalException, SystemException {
        super(name, role);
        setRole(role);
    }

    private RoleEvent(String name, Role oldRole, Role newRole) throws PortalException, SystemException {
        this(name, newRole);
        setOldRole(oldRole);
    }

    public void setOldRole(String role) {
        set(OLD_ROLE_ENTRY, role);
    }

    public String getOldRole() {
        return (String) get(OLD_ROLE_ENTRY);
    }

    private void setOldRole(Role oldRole) throws PortalException, SystemException {
        setOldRole(getRoleIdentifier(oldRole));
    }

    public static RoleEvent newCreatedEvent(Role role) {
        try {
            return new RoleEvent(CREATED_NAME, role);
        } catch (PortalException | SystemException e) {
            log.error("Cannot create event from Role model object", e);
            return null;
        }
    }

    public static RoleEvent newDeletedEvent(Role role) {
        try {
            return new RoleEvent(DELETED_NAME, role);
        } catch (PortalException | SystemException e) {
            log.error("Cannot create event from Role model object", e);
            return null;
        }
    }

    public static RoleEvent newUpdatedEvent(Role oldRole, Role newRole) {
        try {
            return new RoleEvent(UPDATED_NAME, oldRole, newRole);
        } catch (PortalException | SystemException e) {
            log.error("Cannot create event from Role model object", e);
            return null;
        }
    }

}