/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalService;
import java.util.HashMap;
import org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class UserGroupRoleModelListener
extends BaseModelListener<UserGroupRole> {
    @Reference
    private EventPublisherFacade eventPublisherFacade;
    @Reference
    private GroupLocalService groupLocalService;

    public void onAfterCreate(UserGroupRole userGroupRole) {
        Group group = this.groupLocalService.fetchGroup(userGroupRole.getGroupId());
        if (group == null || !group.isSite() || !group.isActive()) {
            return;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("event", "USER_GROUP_ROLE_ADD");
        payload.put("userId", userGroupRole.getUserId());
        payload.put("groupId", userGroupRole.getGroupId());
        payload.put("roleId", userGroupRole.getRoleId());
        this.eventPublisherFacade.publish("usergrouprole.event", payload);
    }

    public void onAfterRemove(UserGroupRole userGroupRole) {
        Group group = this.groupLocalService.fetchGroup(userGroupRole.getGroupId());
        if (group == null || !group.isSite() || !group.isActive()) {
            return;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("event", "USER_GROUP_ROLE_REMOVE");
        payload.put("userId", userGroupRole.getUserId());
        payload.put("groupId", userGroupRole.getGroupId());
        payload.put("roleId", userGroupRole.getRoleId());
        this.eventPublisherFacade.publish("usergrouprole.event", payload);
    }
}

