/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class TokenUtil {
    private static final Log _log = LogFactoryUtil.getLog(TokenUtil.class);

    public static String resolveUserToken(final String username, final String scope) {
        try {
            Class<?> secretProviderClass = Class.forName("org.gcube.common.security.providers.SecretManagerProvider");
            Object secret = secretProviderClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            Class<?> authorizedTasksClass = Class.forName("org.gcube.common.security.AuthorizedTasks");
            Class<?> secretClass = Class.forName("org.gcube.common.security.Secret");
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    try {
                        Class<?> authServiceClass = Class.forName("org.gcube.common.authorization.library.AuthorizationService");
                        Object authService = authServiceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        try {
                            Method resolveMethod = authServiceClass.getMethod("resolveTokenByUserAndContext", String.class, String.class);
                            return (String)resolveMethod.invoke(authService, username, scope);
                        }
                        catch (Throwable notFound) {
                            try {
                                Class<?> userInfoClass = Class.forName("org.gcube.common.authorization.library.provider.UserInfo");
                                ArrayList roles = new ArrayList();
                                Object userInfo = userInfoClass.getConstructor(String.class, List.class).newInstance(username, roles);
                                Method genUserToken = authServiceClass.getMethod("generateUserToken", userInfoClass, String.class);
                                String token = (String)genUserToken.invoke(authService, userInfo, scope);
                                _log.debug((Object)("generateUserToken OK for " + username + " in scope " + scope));
                                return token;
                            }
                            catch (Throwable tryAlt) {
                                try {
                                    Method genAuthToken = authServiceClass.getMethod("generateAuthorizationToken", String.class, String.class);
                                    String token = (String)genAuthToken.invoke(authService, username, scope);
                                    _log.debug((Object)("generateAuthorizationToken OK for " + username + " in scope " + scope));
                                    return token;
                                }
                                catch (Throwable finalFail) {
                                    _log.error((Object)("AuthorizationService token generation failed for user " + username + " in scope " + scope), finalFail);
                                    return null;
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        _log.error((Object)"Error invoking AuthorizationService via reflection", e);
                        return null;
                    }
                }
            };
            Object token = authorizedTasksClass.getMethod("executeSafely", Callable.class, secretClass).invoke(null, task, secret);
            return token != null ? (String)token : TokenUtil.generateAuthorizationToken(username, scope);
        }
        catch (Throwable t) {
            _log.warn((Object)("gCube Secret/AuthorizedTasks not available, fallback token for user=" + username + " scope=" + scope));
            return TokenUtil.generateAuthorizationToken(username, scope);
        }
    }

    private static String generateAuthorizationToken(String username, String scope) {
        return "token_" + username + "_" + scope + "_" + System.currentTimeMillis();
    }
}

