/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import java.util.HashMap;
import org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class RoleModelListener
extends BaseModelListener<Role> {
    @Reference
    private EventPublisherFacade eventPublisherFacade;

    public void onAfterCreate(Role role) {
        if (role.getType() != 2) {
            return;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("event", "ROLE_CREATE");
        payload.put("roleId", role.getRoleId());
        payload.put("name", role.getName());
        payload.put("type", role.getType());
        this.eventPublisherFacade.publish("role.event", payload);
    }

    public void onAfterRemove(Role role) {
        if (role.getType() != 2) {
            return;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("event", "ROLE_DELETE");
        payload.put("roleId", role.getRoleId());
        payload.put("name", role.getName());
        this.eventPublisherFacade.publish("role.event", payload);
    }
}

