/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr74.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import java.util.HashMap;
import org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class}, property={"model.class.name=com.liferay.portal.kernel.model.Group"})
public class GroupEventPublisherModelListener
extends BaseModelListener<Group>
implements ModelListener<Group> {
    private static final Log _log = LogFactoryUtil.getLog(GroupEventPublisherModelListener.class);

    public void onAfterCreate(Group model) {
        if (!model.isSite()) {
            return;
        }
        this.publish("GROUP_CREATE", model);
    }

    public void onBeforeRemove(Group model) {
        if (!model.isSite()) {
            return;
        }
        this.publish("GROUP_DELETE", model);
    }

    private void publish(String eventName, Group group) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("event", eventName);
            payload.put("groupId", group.getGroupId());
            payload.put("companyId", group.getCompanyId());
            payload.put("name", group.getName());
            payload.put("friendlyURL", group.getFriendlyURL());
            EventPublisherFacade.getInstance().publish("group.event", payload);
        }
        catch (Throwable t) {
            _log.warn((Object)("Failed to publish group event " + eventName + ": " + t.getMessage()));
        }
    }
}

