package org.gcube.portal.event.publisher.lr74.action;

import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.service.component.annotations.Component;

@Component(
    immediate = true,
    service = LifecycleAction.class,
    property = {
        "key=login.events.post"
    }
)
public class PostLoginAction implements LifecycleAction {

    private static final Log _log = LogFactoryUtil.getLog(PostLoginAction.class);

    @Override
    public void processLifecycleEvent(LifecycleEvent lifecycleEvent) {
        _log.info("[EventPublisher] PostLoginAction invoked");
        try {
            org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade.getInstance()
                .onPostLogin(lifecycleEvent);
        } catch (Exception e) {
            _log.error("PostLoginAction failed", e);
        }
    }
}