package org.gcube.portal.custom.communitymanager.components;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;


/**
 * 
 * @author Massimiliano Assante, massimiliano.assante@isti.cnr.it
 * @version 1.1 Jan 5th 2012
 * 
 *
 */
public class GCUBELayoutTab {
	/**
	 * the caption to display
	 */
	String caption;
	/**
	 * the description, if any
	 */
	String description;
	/**
	 * the last part of the URL after last slash, autogenerated if not set
	 */
	String friendlyURL;
	/**
	 * set to true if you don't want to show the tab
	 */
	boolean hidden;
	/**
	 * the type of the layout
	 */
	private GCUBELayoutType type;
	/**
	 * list of portlets to place in the layout
	 */
	private List<GCUBEPortlet> portlets;
	/**
	 * list of portlets to place in the layout
	 */
	private ArrayList<GCUBELayoutTab> subtabs;
	/**
	 * 
	 * @param caption the tab caption
	 * @param type the type of the layout
	 * @param portlets a list of <class>GCUBEPortlet</class> to place in the layout, list order is used as layout order
	 */
	public GCUBELayoutTab(String caption, GCUBELayoutType type, List<GCUBEPortlet> portlets) {
		this.caption = caption;
		this.friendlyURL = "/" + caption.replaceAll(" ", "-");
		this.portlets = portlets;
		this.type = type;
		this.hidden = false;
	}	
	/**
	 * 
	 * @param caption the tab caption
	 * @param description the tab description	
	 * @param type the type of the layout
	 * @param portlets a list of <class>GCUBEPortlet</class> to place in the layout, list order is used as layout order
	 */
	public GCUBELayoutTab(String caption, String description, GCUBELayoutType type, List<GCUBEPortlet> portlets) {
		this(caption, type, portlets);
		this.description = description;
	}
	/**
	 * 
	 * @param caption the tab caption
	 * @param type the type of the layout
	 * @param portlet a single <class>GCUBEPortlet</class> to place in the layout
	 */
	public GCUBELayoutTab(String caption, GCUBELayoutType type, GCUBEPortlet portlet) {
		this(caption, type, new ArrayList<GCUBEPortlet>());
		ArrayList<GCUBEPortlet> toPass = new ArrayList<GCUBEPortlet>();
		toPass.add(portlet);
		this.portlets = toPass;
	}
	/**
	 * method to add children tabs
	 * @param subtab
	 */
	public void addSubTab(GCUBELayoutTab subtab) {
		if (subtabs == null) 
			subtabs = new ArrayList<GCUBELayoutTab>();
		subtabs.add(subtab);
	}
	
	public boolean hasChildren() {
		if (subtabs == null) return false;
		return (! subtabs.isEmpty() );
	}
	/**
	 * 
	 * @return
	 */
	public ArrayList<GCUBELayoutTab> getSubTabs() {
		if (subtabs == null) return new ArrayList<GCUBELayoutTab>();
		return subtabs;
	}
	/**
	 * 
	 * @return the type
	 */
	public GCUBELayoutType getType() {
		return type;
	}
	/**
	 * 
	 * @return the list of portlets
	 */
	public List<GCUBEPortlet> getPortlets() {
		return portlets;
	}
	/**
	 * 
	 * @return .
	 */
	public String getCaption() {
		return caption;
	}
	/**
	 * 
	 * @param caption the caption to display
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	/**
	 * 
	 * @return description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * 
	 * @param description desc
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * 
	 * @return the string representing the last part of the URL
	 */
	public String getFriendlyURL() {
		return friendlyURL;
	}
	/**
	 * 
	 * @param friendlyURL  the last part of the URL after slash, autogenerated if not set
	 */
	public void setFriendlyURL(String friendlyURL) {
		this.friendlyURL = friendlyURL;
	}
	/**
	 * 
	 * @return .
	 */
	public boolean isHidden() {
		return hidden;
	}
	/**
	 * 
	 * @param hidden -
	 */
	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}	

	/** 
	 * create the layout with portlets in it
	 * 
	 * 1_column - gives you a single column layout
	 * 2_columns_i - gives you two columns split 50/50
	 * 2_columns_ii - gives you two columns split 30/70
	 * 2_columns_iii - gives you two columns split 70/30
	 * 3_columns - gives you three columns
	 * 1_2_columns_i - gives you one top initial row, followed by 2 columns split 30/70
	 * 1_2_columns_ii - gives you one top initial row, followed by 2 columns split 70/30
	 * 1_2_1_columns - gives you one top initial row, followed by a row with 2 columns 50/50 split, followed by another row
	 * 2_2_columns - gives you one row with 2 columns 70/30 split followed by another row with 2 columns 30/70 split.
	 * 
	 *  * e.g.
	 * 
	 *  typeSettings = "layout-template-id=1_2_columns_i\n";
     *  typeSettings += "column-1=73,\n";
	 *  typeSettings += "column-2=107,\n";
	 *  typeSettings += "column-3=8,";    
	 * 
	 * @return the TypeSettings layout for liferay
	 */
	public String getLayoutTypeSettings() {
		String typeSettings = "";
		/**
		 * choose the appropriate layout 
		 */
		switch (getType()) {
		case ONE_COL:			
			typeSettings = "layout-template-id=1_column\n";
			break;
		case TWO_COL_5050:
			typeSettings = "layout-template-id=2_columns_i\n";
			break;
		case TWO_COL_3070:
			typeSettings = "layout-template-id=2_columns_ii\n";
			break;
		case TWO_COL_7030:
			typeSettings = "layout-template-id=2_columns_iii\n";
			break;
		case THREE_COL:
			typeSettings = "layout-template-id=3_columns\n";
			break;
		case TWO_ROWS_1_2_3070:
			typeSettings = "layout-template-id=1_2_columns_i\n";
			break;
		case TWO_ROWS_1_2_7030:
			typeSettings = "layout-template-id=1_2_columns_ii\n";
			break;
		case TWO_ROWS_2_7030_2_3070:
			typeSettings = "layout-template-id=2_2_columns\n";
			break;
		case THREE_ROWS_1_2_5050_1:
			typeSettings = "layout-template-id=1_2_1_columns\n";
			break;
		}
		/**
		 * fill the layout with actual portlets
		 */
		for (int i = 1; i <= portlets.size(); i++) {
			 typeSettings += "column-"+i+"="+ portlets.get(i-1).getPortletId() + ",\n";
		}
		return typeSettings;
	}
}
