package org.gcube.personalization.userprofileaccess.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.io.IOUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;

import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SMSUtils {

	private static final String serviceName = "UserProfileAccess";
	private static final String serviceClass = "Personalisation";
	private static final String directory = "/userprofiles/";
	
	static GCUBELog logger = new GCUBELog(SMSUtils.class);

	/**
	 * Creates a new document into userprofiles remote directory
	 * 
	 * @param documentName The document's name
	 * @param payload The document'd payload
	 * @return The document's ID
	 * @throws GCUBEFault Failed to create the document
	 */
	protected static String createDocument(String documentName, String payload)throws GCUBEFault{ //, GCUBEScope scope) throws GCUBEFault{
		try {
			//ScopeProvider.instance.set(scope.toString());
			logger.debug("Trying to create a new document in SMS.....");
			logger.debug("NAME --> " + documentName);
			logger.debug("payload --> " + payload);

			InputStream is = new ByteArrayInputStream(payload.getBytes());
			
			IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
			String documentID = client.put(true).LFile(is).RFile(directory + documentName + ".xml");
			
			return documentID;
		} catch (Exception e) {
			logger.error("Failed to create a new document with name " + documentName, e);
			throw new GCUBEUnrecoverableFault("Failed to create a new document with name " + documentName);
		}	 
	}

	/**
	 * This method retrieves the content of the document with the given ID that belongs to the given collection
	 * 
	 * @param DocumentReader The CM Document reader for the given document
	 * @param documentID The ID of the document to be retrieved
	 * @param scope The scope
	 * @return The payload of the document
	 * @throws GCUBEFault
	 */
	protected static String getDocument(String documentName)throws GCUBEFault{//, GCUBEScope scope) throws GCUBEFault {
		String content = null;
		try {
			//ScopeProvider.instance.set(scope.toString());
			IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
			InputStream in = client.get().RFileAsInputStream(directory + documentName + ".xml");
			content = IOUtils.toString(in, "UTF-8");
		
			if (content == null) {
				logger.error("document --> " + documentName + " does not exist.");
				throw new GCUBEUnrecoverableException("Document does not exist.");
			}
		} catch (Exception e) {
			logger.error("Failed to get the profile. an exception was thrown", e);
			throw new GCUBEUnrecoverableFault("Failed to get the profile. An exception was trhown");
		}
		return content;
	}

	/**
	 * This method updates the document with the given ID that belongs to the given collection
	 * 
	 * @param DocumentWriter The CM Document writer for the given document
	 * @param documentID The ID of the document to be updated
	 * @param newContent The new payload of the document
	 * @param scope The scope
	 * @throws GCUBEFault 
	 */
	protected static void updateDocument(String documentName, String newContent)throws GCUBEFault{//, GCUBEScope scope) throws GCUBEFault {
		try {
			//ScopeProvider.instance.set(scope.toString());
			logger.debug("Trying to update document --> " + documentName);
			logger.debug("New content to be set is --> " + newContent);
			InputStream is = new ByteArrayInputStream(newContent.getBytes());
			
			IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
			client.put(true).LFile(is).RFile(directory + documentName + ".xml");
			logger.debug("Document has been updated!");
		} catch (Exception e) {
			logger.error("Failed to update the document --> " + documentName + ". An exception was thrown", e);
			throw new GCUBEUnrecoverableFault("Failed to update the document --> " + documentName + ". An exception was thrown");
		}

	}

	/**
	 * This method parses a string using the Document Builder parser
	 * 
	 * @param XMLdoc: the string to parse
	 * @return: the parsed document
	 * @throws ParserConfigurationException 
	 * @throws SAXException 
	 * @throws IOException
	 */ 
	protected static Document parseXMLFileToDOM(String XMLdoc) throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = dbFactory.newDocumentBuilder();
		Document doc = builder.parse(new InputSource(new StringReader(XMLdoc)));
		return doc;
	}

	/**
	 * This method converts a node of a tree to a string representation.
	 * 
	 * @param tree The node of a document that will be transformed
	 * @return A string representation of the node
	 * @throws TransformerException failed to transform the DOMTree to String
	 */
	protected static String createStringFromDomTree(Node tree) throws TransformerException {
		String nodeString = null;
		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();
		transformer.setOutputProperty("omit-xml-declaration", "yes");
		StringWriter sw = new StringWriter();
		StreamResult result = new StreamResult(sw);
		DOMSource source = new DOMSource(tree);
		transformer.transform( source, result );
		nodeString = sw.getBuffer().toString();

		return nodeString;
	}

}
