package org.gcube.personalization.userprofileaccess.impl;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;


import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;

/**
 * Resource Persistence Delegate 
 * 
 * Implements Resource RPs persistence on file
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class ResourcePersistenceDelegate extends GCUBEWSFilePersistenceDelegate<UserProfileAccessResource>{

	protected void onLoad(UserProfileAccessResource resource,ObjectInputStream ois) throws Exception {
		
		super.onLoad(resource,ois);
		resource.setUsername((String)ois.readObject());
		resource.setUserProfileID((String)ois.readObject());
	}
	
	protected void onStore(UserProfileAccessResource resource,ObjectOutputStream oos) throws Exception {
		
		super.onStore(resource,oos);
		oos.writeObject(resource.getUsername());
		oos.writeObject(resource.getUserProfileID());
		
	}
}
