package org.gcube.personalization.userprofileaccess.impl;

import java.util.LinkedList;
import java.util.List;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.container.ServiceHost;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessFactoryService extends GCUBEPortType{

	private static final String fPath = "gcube/personalization/userprofileaccess/UserProfileAccessFactory";
	private EndpointReferenceType sEpr = new EndpointReferenceType();
	private static GCUBELog logger = new GCUBELog(UserProfileAccessFactoryService.class);
	static ISClient client = null;

	private static final String UserProfileID = "UserProfileID";
	private static final String DefaultUserProfile = "DefaultUserProfile";

	/**
	 * The constructor of the class
	 * @throws GCUBEFault  Failed to contact the IS client
	 *
	 */
	public UserProfileAccessFactoryService() throws GCUBEFault {
		try {
			client =GHNContext.getImplementation(ISClient.class);
		} catch (Exception e) {
			throw new GCUBERetrySameFault("Failes to call the IS client");
		}	
		String address = null;
		try {
			address = ServiceHost.getBaseURL().toString() + UserProfileAccessFactoryService.fPath;
			sEpr.setAddress(new Address(address));
			logger.info("own EPR is: " + sEpr);
		} catch (Exception e1) {
			throw new GCUBERetrySameFault("Failes to get own service epr");
		} 
	}

	@Override
	protected GCUBEServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	/**
	 * This method gets the ID of the profile, which is saved as a resource property
	 * in a WS-resource of the service UserProfileAccess.
	 * 
	 * @param epr: the Epr of the resource
	 * @return the unique Id of the user's profile stored in CMS
	 * @throws GCUBEFault an error occurred
	 */
	private String getProfileId(EndpointReferenceType epr) throws GCUBEFault {
		/* Gets the value of the Resource property "UserProfileId" */
		try {
			WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
			gquery.addAtomicConditions(
					new AtomicCondition("/../Source", epr.getAddress().toString()),
					new AtomicCondition("/../SourceKey", epr.getProperties().get_any()[0].getValue())
					);              
			for(RPDocument d : client.execute(gquery, ServiceContext.getContext().getScope())){
				return d.evaluate("//" + UserProfileID + "/text()").get(0);
			}
		}catch(Exception e) {
			logger.error("Failed to get the requested property.",e);
			throw new GCUBEUnrecoverableFault("Failed to get the requested property.");
		}
		return null;
	}



	/**
	 * This method retrieves the Generic Resources from the IS that contain specific strings in their name
	 * 
	 * @param nameParts An array with the strings to be contained in the name of the generic resource
	 * @param scope The scope
	 * @return A list with the name and the ID for all the generic resources
	 * @throws Exception name parts are not specified
	 */
//	private static List<String[]> retrieveGenericResourcesFromNameParts(String[] nameParts, GCUBEScope scope) throws Exception {
//		if (nameParts.length == 0)
//			throw new Exception("At least one name part has to be specified");
//
//		String condition = "contains($result/Profile/Name/string(), '" + nameParts[0] + "')";
//		for (int i=1; i<nameParts.length; i++)
//			condition += " and contains($result/Profile/Name/string(), '" + nameParts[i] + "')";
//
//		GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
//		query.addParameters(new QueryParameter("FILTER", condition),
//				new QueryParameter("TYPE", GCUBEGenericResource.TYPE),
//				new QueryParameter("RESULT", "<Result>{$result/ID}{$result/Profile/Name}</Result>"));
//
//		List<XMLResult> result = client.execute(query, scope);
//		List<String[]> ret = new LinkedList<String[]>();
//		if (result==null || result.size()==0)
//			throw new Exception("No generic resources were found.");
//
//		for(XMLResult r : result){
//			String[] nameAndID = { r.evaluate("//Name/text()").get(0), r.evaluate("//ID/text()").get(0) };
//			ret.add(nameAndID);
//		}
//		return ret;
//	} 

	//	/**
	//	 * This method retrieves the default (presentation or metadata) XSLTs for each schema, which are stored
	//	 * as generic resources on the IS
	//	 * 
	//	 * @param xsltType The type of the xslt: Presentation or Metadata
	//	 * @return The Name and the ID of the XSLTs, null if no Xslts found
	//	 * @throws GCUBEFault an error occurred
	//	 */
	//	private String[][] getDefaultXslts(String xsltType) throws GCUBEFault {
	//		String pairs[][] = null;
	//		try{
	//			// the symbols that splits the name has changed
	//			String[] nameParts = { xsltType, "-|-default" };
	//			List<String[]> namesAndIDs = retrieveGenericResourcesFromNameParts(nameParts, ServiceContext.getContext().getScope());
	//			pairs = new String[namesAndIDs.size()][2];
	//			for (int i=0; i<namesAndIDs.size(); i++) {
	//				pairs[i][0] = namesAndIDs.get(i)[0]; // The name of the xslt
	//				pairs[i][1] = namesAndIDs.get(i)[1]; // The ID of the xslt
	//			}
	//		} catch (Exception e) {
	//			logger.error("Failed to retrieve the xslts", e);
	//			logger.debug("Default XLSTs do not exist on the IS. The new profile will not contain any XSLT");
	//			return null;
	//		}
	//		return pairs;
	//	}

	/**
	 * This method retrieves the the default user profile which is stored to IS.
	 * 
	 * @param name The name of the default user profile
	 * @return: the default user profile
	 * @throws GCUBEFault an error occurred
	 */
	private String getDefaultProfile(String name) throws GCUBEFault {
		try{
			GCUBEGenericResourceQuery query = client.getQuery(GCUBEGenericResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/Name", name));
			List<GCUBEGenericResource> result = client.execute(query, ServiceContext.getContext().getScope());
			if (result==null || result.size()==0)
				throw new Exception("Generic resource not found.");
			logger.debug("Default profile retrieved. The ID of the resource is --> " + result.get(0).getID());
			return result.get(0).getBody();
		}catch (Exception e) {
			logger.error("Error while trying to retrieve the default user profile",e);
			throw new GCUBEUnrecoverableFault("Error while trying to retrieve the default user profile");
		}
	}

	static String getGenericResourceNameByID(String id, GCUBEScope scope) throws GCUBEFault {
		try{
			GCUBEGenericResourceQuery query = client.getQuery(GCUBEGenericResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("/ID", id));
			List<GCUBEGenericResource> result = client.execute(query, scope);
			if (result==null || result.size()==0)
				throw new Exception("Generic resource not found.");
			return result.get(0).getName();
		}catch (Exception e) {
			logger.error("Error while trying to retrieve the name of the generic resource with ID: " + id,e);
			throw new GCUBEUnrecoverableFault("Error while trying to retrieve the name of the generic resource with ID: " + id);
		}
	}

	/**
	 * It creates a resource with resource properties: the username and the unique ID of
	 * the user profile that creates. The user profile is stored in CMS.
	 * 
	 * @param username The user's username
	 * @return the EPR of the new resource
	 * @throws GCUBEFault an error occurred
	 */ 
	public EndpointReferenceType createResource(String username) throws GCUBEFault{
		logger.debug("Start creating the resource..................");
		String ID = null;

		EndpointReferenceType epr = null;

		//GCUBEScope scope = ServiceContext.getContext().getScope();
		String scope = ScopeProvider.instance.get();
		ScopeBean scopeBean = new ScopeBean(scope);
		String scopeName = scopeBean.name();
		
		// i.e. giota_NextNext
		String docName = username + "_" + scopeName;

		List<EndpointReferenceType> result = new LinkedList<EndpointReferenceType>();
		try {
			AtomicCondition cond = new AtomicCondition("/../SourceKey", username+"."+scopeName);
			WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
			gquery.addAtomicConditions(cond);
			gquery.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq 'UserProfileAccess'");
			for(RPDocument d : client.execute(gquery, ServiceContext.getContext().getScope()))
				result.add(d.getEndpoint());
			if (result == null || result.size() == 0) {
				logger.info("There is no WS-Resource for the requested profile. A new WS-Resource will be created");
			}
		}catch(Exception e){
			logger.error("Failed to get the WS-Resources",e);
			throw new GCUBEUnrecoverableFault("Failed to get the WS-Resources.");
		}

		/* From now there can be more than one resources */
		if (result != null && result.size() > 0) {
			for (int j=0; j<result.size(); j++) {
				logger.debug("EPR --> " + result);
				if (result.get(j).getAddress().toString().startsWith(sEpr.getAddress().toString().substring(0,sEpr.getAddress().toString().lastIndexOf('/') ))) {
					epr = result.get(j);
					break;
				}
			}
			/* If there is a resource that had been created from this RI return this, else create a new WS-Resource */
			if (epr != null) {
				logger.info("There is already a ws-resource that had been created by the same RI of the UserProfileAccess. Return this rersource");
				return epr;
			}
			/* Ws resources exist for this user but they hadn't been created from this RI.
			 * From one of these resources get the ID of the user profile stored in CMS.
			 */
			else {
				logger.info("Ws-resources exist for this user, but they hadn't been created by this RI. A new ws-Resource will be created");
				ID = getProfileId(result.get(0));
				logger.info("The ID to be assigned to the new ws-resource is -> " + ID);
			}
		}

		GCUBEWSResource wsResource = null;
		GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();

		/* No WS - resource found for this user */
		if (ID == null) {
			logger.info("The returned id of the cms is null. Create a new user profile in cms for user --> " + username);
			String pr = getDefaultProfile(DefaultUserProfile);

			try {
				Document doc = SMSUtils.parseXMLFileToDOM(pr);
				XPath xpath = XPathFactory.newInstance().newXPath();
				Element eUsername = (Element) xpath.evaluate("/userprofile/userinfo/username", doc, XPathConstants.NODE);
				eUsername.setTextContent(username);

				pr = SMSUtils.createStringFromDomTree(doc);
				ID = SMSUtils.createDocument(docName, pr);
			} catch (Exception e) {
				logger.error("Error while trying to create user's profile in CMS. Throwing exception." + e.getMessage(), e);
				throw new GCUBEUnrecoverableFault("Error while trying to create user's profile in CMS.");
			}
		}

		/* Create resource */
		/* The resource is published automatically by gCF */
		try {
			// The key of the ws-resource is the username '.' the scope name
			wsResource = ptcxt.getWSHome().create(ptcxt.makeKey(username+"_"+scopeName), username, ID);
			// Store the resource to enable persistence
			wsResource.store();
			epr = wsResource.getEPR();

		} catch (Exception e) {
			logger.error("An error occured while creating the resource. Throwing exception",e);
			throw new GCUBEUnrecoverableFault("Error while creating the WS-Resource .");
		}

		logger.info("Profile stored in SMS with ID: '" + ID + "' for the user: " + username);

		return epr;
	}
}

