/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMSUtils {
    static GCUBELog logger = new GCUBELog(CMSUtils.class);

    protected static String createDocument(DocumentWriter writer, String documentName, String payload, GCUBEScope scope) throws GCUBEFault {
        try {
            logger.debug((Object)"Trying to create a new document in CMS.....");
            logger.debug((Object)("NAME --> " + documentName));
            logger.debug((Object)("payload --> " + payload));
            GCubeDocument document = new GCubeDocument();
            document.setName(documentName);
            document.setBytestream(payload.getBytes("UTF-8"));
            document.setMimeType("text/xml");
            String documentId = writer.add(document);
            logger.info((Object)("A new document has been created with name --> " + documentName + " and ID --> " + documentId));
            return documentId;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create a new document to the collection with ID--> " + writer.collectionID() + " with name " + documentName), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to create a new document to the collection with ID--> " + writer.collectionID() + " with name " + documentName});
        }
    }

    protected static DocumentReader getDocumentReaderByID(String collectionID, GCUBEScope scope) throws Exception {
        try {
            return new DocumentReader(collectionID, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected static DocumentReader getDocumentReaderByCollectionReference(CollectionReference colRef, GCUBEScope scope) throws Exception {
        try {
            return new DocumentReader(colRef, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected static DocumentWriter getDocumentWriterByID(String collectionID, GCUBEScope scope) throws Exception {
        try {
            return new DocumentWriter(collectionID, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected static DocumentWriter getDocumentWriterByCollectionReference(CollectionReference colRef, GCUBEScope scope) throws Exception {
        try {
            return new DocumentWriter(colRef, scope);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    protected static String getDocument(DocumentReader reader, String documentID, GCUBEScope scope) throws GCUBEFault {
        String content = null;
        try {
            GCubeDocument doc = reader.get(documentID, (Projection)Projections.document().with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.DocumentProperty[0]));
            if (doc.bytestream() == null) {
                logger.error((Object)("document with ID --> " + documentID + "does not have any content."));
                throw new GCUBEUnrecoverableException("Document does not have any content.");
            }
            byte[] bytes = doc.bytestream();
            content = new String(bytes);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the profile. an exception was thrown", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the profile. An exception was trhown"});
        }
        return content;
    }

    protected static void updateDocument(DocumentWriter writer, String documentID, String newContent, GCUBEScope scope) throws GCUBEFault {
        try {
            logger.debug((Object)("Trying to update a document with ID --> " + documentID));
            logger.debug((Object)("New content to be set is --> " + newContent));
            GCubeDocument virtualDocument = new GCubeDocument(documentID);
            virtualDocument.setBytestream(new byte[0]);
            virtualDocument.trackChanges();
            virtualDocument.setBytestream(newContent.getBytes("UTF-8"));
            writer.update(virtualDocument);
            logger.debug((Object)"Document has been updated!");
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update the document with ID --> " + documentID + ". An exception was thrown"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to update the document with ID --> " + documentID + ". An exception was thrown"});
        }
    }

    protected static String getCollectionByName(String name, GCUBEScope scope) {
        try {
            List collections = Collections.findByName((GCUBEScope)scope, (String)name);
            if (collections != null && collections.size() > 0) {
                if (collections.size() > 1) {
                    logger.debug((Object)"More than one collections detected with the same name. The first one will be used");
                }
                logger.info((Object)("Returning the ID of the collection with name --> " + name + ". The ID is --> " + ((Collection)collections.get(0)).getId()));
                return ((Collection)collections.get(0)).getId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("An exception was thrown while trying to find the collection with name: " + name));
            return null;
        }
        return null;
    }

    protected static CollectionReference createCollection(String name, String description, GCUBEScope scope) {
        List collectionReferences;
        CollectionReference colRef = null;
        boolean propagateRequest = true;
        boolean readable = true;
        boolean writable = true;
        try {
            collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)name, (String)description, (boolean)false, (boolean)readable, (boolean)writable, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"An exception was thrown while trying to create a collection.", (Throwable)e);
            return colRef;
        }
        if (collectionReferences != null) {
            logger.debug((Object)("Collection with name: " + name + " has just been created. Only one reference should have been returned"));
            if (collectionReferences.size() > 1) {
                logger.debug((Object)"More than one references have been returned. The first one will be used");
            }
            colRef = (CollectionReference)collectionReferences.get(0);
            logger.debug((Object)("The ID of the created collection is " + colRef.getCollectionID()));
        }
        return colRef;
    }

    protected static String findDocumentIDFromName(DocumentReader reader, String name, GCUBEScope scope) throws GCUBEFault {
        GCubeDocument document = null;
        try {
            DocumentProjection projection = (DocumentProjection)Projections.document().withValue((Property)Projections.NAME, (Object)name);
            RemoteIterator documentIterator = reader.get((Projection)projection);
            if (!documentIterator.hasNext()) {
                logger.debug((Object)("There are no documents with the name --> " + name));
                return null;
            }
            document = (GCubeDocument)documentIterator.next();
            logger.debug((Object)("Found document with ID: " + document.id() + " and name: " + name));
            return document.id();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to find the ID of the document with name: " + name + ". An exception was thrown"), (Throwable)e);
            throw new GCUBEUnrecoverableFault(e, new String[]{"Failed to find the ID of the document with name: " + name});
        }
    }

    protected static Document parseXMLFileToDOM(String XMLdoc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbFactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(XMLdoc)));
        return doc;
    }

    protected static String createStringFromDomTree(Node tree) throws TransformerException {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }
}

