/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.profileadministration.impl;

import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.rmi.Remote;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.personalization.profileadministration.impl.ServiceContext;
import org.gcube.personalization.profileadministration.stubs.ValidateProfile;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessFactoryPortType;
import org.gcube.personalization.userprofileaccess.stubs.UserProfileAccessPortType;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessFactoryServiceAddressingLocator;
import org.gcube.personalization.userprofileaccess.stubs.service.UserProfileAccessServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ProfileAdministrationService
extends GCUBEPortType {
    static GCUBELog logger = new GCUBELog(ProfileAdministrationService.class);
    static ISClient client = null;
    private static final String serviceName = "UserProfileAccess";
    private static final String serviceClass = "Personalisation";
    private static final String directory = "/userprofiles/";
    private static final String userProfileIDProperty = "UserProfileID";

    public ProfileAdministrationService() throws GCUBEFault {
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            throw new GCUBERetrySameFault(new String[]{"Failes to call the IS client"});
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    private UserProfileAccessFactoryPortType getUserProfileAccessServiceAddress() throws GCUBEFault {
        try {
            List result = null;
            GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", serviceName), new AtomicCondition("//ServiceClass", serviceClass)});
            result = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            if (result == null || result.size() == 0) {
                throw new GCUBERetrySameException("Failed to get address of the running instance of the service UserProfileAccess.");
            }
            EndpointReferenceType endpoint = ((GCUBERunningInstance)result.get(new Random().nextInt(result.size()))).getAccessPoint().getEndpoint("gcube/personalization/userprofileaccess/UserProfileAccessFactory");
            logger.debug((Object)("UPA RI endpoint is to be used: '" + endpoint.toString() + "'"));
            UserProfileAccessFactoryPortType upa = null;
            UserProfileAccessFactoryServiceAddressingLocator upalocator = new UserProfileAccessFactoryServiceAddressingLocator();
            upa = upalocator.getUserProfileAccessFactoryPortTypePort(endpoint);
            upa = (UserProfileAccessFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)upa, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
            return upa;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to contact UserProfileAccess service. Could not get a running instance.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to contact UserProfileAccess service. Could not get a running instance."});
        }
    }

    private List<EndpointReferenceType> getResourceEpr(String username) throws GCUBEFault {
        LinkedList<EndpointReferenceType> result = new LinkedList<EndpointReferenceType>();
        try {
            AtomicCondition cond = new AtomicCondition("/../SourceKey", username + "_" + ServiceContext.getContext().getScope().getName());
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{cond});
            gquery.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq 'UserProfileAccess'");
            for (RPDocument d : client.execute((ISQuery)gquery, ServiceContext.getContext().getScope())) {
                result.add(d.getEndpoint());
            }
            if (result == null || result.size() == 0) {
                logger.info((Object)("There is no WS-Resource for the requested profile with username: " + username));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the WS-Resources", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the WS-Resources."});
        }
        return result;
    }

    private String getProfile(String profileName) throws GCUBEFault {
        String ret = null;
        try {
            IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
            InputStream in = client.get().RFileAsInputStream(directory + profileName + ".xml");
            ret = IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get the requested profile with name: " + profileName));
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the requested profile with name: " + profileName});
        }
        return ret;
    }

    private GCUBEGenericResource getDefaultProfileGenericResource(String name) throws GCUBEFault {
        try {
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", name)});
            List result = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            if (result == null || result.size() == 0) {
                logger.info((Object)"The resource: DefaultUserProfile is null");
                return null;
            }
            logger.info((Object)("The ID of the generic resource DefaultUserProfile is: " + ((GCUBEGenericResource)result.get(0)).getID()));
            return (GCUBEGenericResource)result.get(0);
        }
        catch (Exception e) {
            logger.error((Object)"Error while trying to retrieve the ID of the default user profile", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to retrieve the ID of the default user profile"});
        }
    }

    public VOID setDefaultProfile(String profile) throws GCUBEFault {
        ISPublisher publisher;
        String name = "DefaultUserProfile";
        String desc = "This is the default user profile";
        String secondaryType = "UserProfile";
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        }
        catch (Exception e1) {
            logger.error((Object)"Failes to call the IS publisher. Retrying.", (Throwable)e1);
            throw new GCUBERetrySameFault(new String[]{"Failes to call the IS publisher."});
        }
        GCUBEGenericResource resource = this.getDefaultProfileGenericResource(name);
        if (resource != null) {
            logger.info((Object)"DefaultUserProfile generic resource already exists. It will be updated");
            try {
                resource.setBody(profile);
                publisher.updateGCUBEResource((GCUBEResource)resource, ServiceContext.getContext().getScope(), (GCUBESecurityManager)ServiceContext.getContext());
                logger.info((Object)"DefaultUserProfile generic resource updated succesfully.");
            }
            catch (Exception e) {
                logger.error((Object)"Failed to update the Default user profile.", (Throwable)e);
                throw new GCUBERetrySameFault(new String[]{"Failed to update the Default user profile."});
            }
        }
        logger.info((Object)"DefaultUserProfile generic resource does not exist. A new one will be created");
        try {
            resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        }
        catch (Exception e1) {
            logger.error((Object)"Failed to call the GCUBEResource client. Retrying.", (Throwable)e1);
            throw new GCUBERetrySameFault(new String[]{"Failed to call the GCUBEResource client"});
        }
        try {
            resource.setName(name);
            resource.setDescription(desc);
            resource.setSecondaryType(secondaryType);
            resource.setBody(profile);
            resource.setID("");
            publisher.registerGCUBEResource((GCUBEResource)resource, ServiceContext.getContext().getScope(), (GCUBESecurityManager)ServiceContext.getContext());
            logger.info((Object)"DefaultUserProfile generic resource created succesfully.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create the Default user profile.", (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{"Failed to create the Default user profile."});
        }
        return new VOID();
    }

    public VOID createUserProfile(String username) throws GCUBEFault {
        UserProfileAccessFactoryPortType port = this.getUserProfileAccessServiceAddress();
        try {
            port.createResource(username);
            logger.info((Object)("Profile for the user: '" + username + "' created succesfully."));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create profile for the user: '" + username + "'."), (Throwable)e);
            throw new GCUBERetrySameFault(new String[]{"Failed to create profile for the user: " + username + "."});
        }
        return new VOID();
    }

    public VOID dropUserProfile(String username) throws GCUBEFault {
        List<EndpointReferenceType> eprs = this.getResourceEpr(username);
        logger.info((Object)("Number of WS resources for the user: '" + username + "' is: " + eprs.size()));
        if (eprs != null && eprs.size() > 0) {
            String sourceKey = eprs.get(0).getProperties().get_any()[0].getValue();
            try {
                IClient client = new StorageClient(serviceClass, serviceName, serviceName, AccessType.SHARED).getClient();
                client.remove().RFile(directory + sourceKey + ".xml");
            }
            catch (Exception e1) {
                logger.error((Object)"Failed to delete the user's profile from SMS. Document with the specified ID does not exist on SMS", (Throwable)e1);
                throw new GCUBEUnrecoverableFault(new String[]{"Failed to delete the user's profile. " + e1.getMessage()});
            }
            for (int i = 0; i < eprs.size(); ++i) {
                try {
                    UserProfileAccessServiceAddressingLocator instanceLocator = new UserProfileAccessServiceAddressingLocator();
                    UserProfileAccessPortType port = instanceLocator.getUserProfileAccessPortTypePort(eprs.get(i));
                    port = (UserProfileAccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)port, (GCUBEScope)ServiceContext.getContext().getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                    port.destroy(new Destroy());
                    logger.info((Object)("WS-resource for the user: '" + username + "' deleted succesfully."));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to delete user's profile with username: " + username), (Throwable)e);
                    throw new GCUBEUnrecoverableFault(new String[]{"Failed to delete user's profile with username: " + username});
                }
            }
        }
        return new VOID();
    }

    public VOID validateProfile(ValidateProfile params) throws GCUBEFault {
        List<EndpointReferenceType> eprs = this.getResourceEpr(params.getUserName());
        String profile = this.getProfile(eprs.get(0).getProperties().get_any()[0].getValue());
        DocumentBuilder builder = null;
        Document docTP = null;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        SchemaFactory sFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            builder = dbFactory.newDocumentBuilder();
            docTP = builder.parse(new InputSource(new StringReader(profile)));
            StreamSource schemaFile = new StreamSource(new File(params.getValidationSchema()));
            Schema schema = sFactory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(docTP));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to validate user's profile.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to validate user's profile."});
        }
        return new VOID();
    }
}

