/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.resource;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.is.InformationSystem;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISResourceRepository
implements ResourceRepository {
    private ISOpenSearchResourceCache cache = null;
    private EnvHintCollection envHints = null;
    private Logger logger = LoggerFactory.getLogger((String)ISResourceRepository.class.getName());

    public ISResourceRepository(ISOpenSearchResourceCache cache, EnvHintCollection envHints) {
        this.cache = cache;
        this.envHints = envHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenSearchResource get(String descriptionDocumentURL) throws Exception {
        OpenSearchResource res;
        String xmlRes = null;
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            res = this.cache.resources.get(descriptionDocumentURL);
            if (res != null) {
                return res;
            }
        }
        xmlRes = InformationSystem.GetOpenSearchGenericByDescriptionDocumentURI((String)descriptionDocumentURL, (EnvHintCollection)this.envHints);
        iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            res = new ISOpenSearchResource(xmlRes, this.cache.descriptionDocuments, this.cache.resourcesXML, this.cache.XSLTs, this.envHints);
            this.cache.resources.put(descriptionDocumentURL, res);
        }
        return res;
    }
}

