/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.client;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchoperator.OpenSearchOp;
import org.gcube.opensearch.opensearchoperator.OpenSearchOpConfig;
import org.gcube.opensearch.opensearchoperator.record.OpenSearchRecord;
import org.gcube.opensearch.opensearchoperator.resource.LocalOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchOpClient {
    private static Logger logger = LoggerFactory.getLogger((String)OpenSearchOpClient.class.getName());
    private OpenSearchResource resource;
    private BufferedWriter fwriter;
    private String query;

    OpenSearchOpClient(OpenSearchResource resource, String query, OutputStream outStream) throws IOException {
        this.fwriter = new BufferedWriter(new OutputStreamWriter(outStream));
        this.resource = resource;
        this.query = query;
    }

    void compute() throws Exception {
        int rc = 0;
        try {
            OpenSearchRecord rec;
            OpenSearchOp osOp = new OpenSearchOp(this.resource, new String[0], new OpenSearchOpConfig(20, false, true, null), new EnvHintCollection());
            URI outLocator = osOp.query(this.query);
            ForwardReader reader = new ForwardReader(outLocator);
            while (reader.getStatus() != IBuffer.Status.Dispose && (reader.getStatus() != IBuffer.Status.Close || reader.availableRecords() != 0) && (rec = (OpenSearchRecord)reader.get(60L, TimeUnit.SECONDS)) != null) {
                ++rc;
                this.fwriter.write(rec.getPayload());
                this.fwriter.newLine();
            }
            reader.close();
            this.fwriter.flush();
            this.fwriter.close();
            System.out.println("Total " + rc + " records");
        }
        catch (Exception e) {
            logger.error("Client error", (Throwable)e);
            throw new Exception("Client error");
        }
    }

    static void printUsageAndExit() {
        System.out.println("Usage:");
        System.out.println("OpenSearchOpClient OpenSearchResourcePath [query] [outFileName] ");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        String query = OpenSearchConstants.searchTermsQName + "=\"earth\" config:numOfResults=\"40\"";
        BufferedOutputStream oos = null;
        if (args.length == 0) {
            OpenSearchOpClient.printUsageAndExit();
        }
        String resourcePath = args[0];
        System.out.println(args[0]);
        if (args.length > 1) {
            query = args[1];
        }
        System.out.println(query);
        oos = args.length > 2 ? new BufferedOutputStream(new FileOutputStream(args[2])) : new BufferedOutputStream(System.out);
        LocalOpenSearchResource resource = new LocalOpenSearchResource(new File(resourcePath), null);
        OpenSearchOpClient cl = new OpenSearchOpClient(resource, query, oos);
        cl.compute();
    }
}

