/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.query;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.opensearch.opensearchlibrary.query.NonExistentParameterException;
import org.gcube.opensearch.opensearchlibrary.query.URLTemplate;

public class BasicURLTemplate
implements URLTemplate {
    private static Pattern paramPattern = Pattern.compile("\\{[^\\}]*\\}");
    protected String template;
    protected List<Parameter> parameters = new ArrayList<Parameter>();

    public BasicURLTemplate(String template, Map<String, String> nsPrefixes) throws Exception {
        Matcher m = paramPattern.matcher(template);
        while (m.find()) {
            String encodedURLParam;
            Parameter paramEntry = new Parameter();
            paramEntry.optional = false;
            String param = m.group().trim();
            if ((param = param.substring(1, param.length() - 1)).charAt(param.length() - 1) == '?') {
                paramEntry.name = param.substring(0, param.length() - 1);
                paramEntry.optional = true;
            } else {
                paramEntry.name = param;
            }
            int index = paramEntry.name.indexOf(":");
            if (index == -1) {
                encodedURLParam = URLEncoder.encode("http://a9.com/-/spec/opensearch/1.1/", "UTF-8") + ":" + paramEntry.name;
            } else {
                String nsPrefix = paramEntry.name.substring(0, index);
                String nsUrl = null;
                for (Map.Entry<String, String> e : nsPrefixes.entrySet()) {
                    if (!e.getValue().equals(nsPrefix)) continue;
                    nsUrl = e.getKey();
                }
                if (nsUrl == null) {
                    throw new Exception("Namespace " + nsPrefix + " is not specified in the description document");
                }
                encodedURLParam = URLEncoder.encode(nsUrl, "UTF-8") + ":" + paramEntry.name.substring(index + 1);
            }
            template = template.replace("{" + paramEntry.name + (paramEntry.optional ? "?" : "") + "}", "{" + encodedURLParam + (paramEntry.optional ? "?" : "") + "}");
            paramEntry.name = encodedURLParam;
            this.parameters.add(paramEntry);
            this.template = template;
        }
    }

    private List<String> getParameters(boolean opt) {
        ArrayList<String> rp = new ArrayList<String>();
        for (Parameter p : this.parameters) {
            if (p.optional != opt) continue;
            rp.add(new String(p.name));
        }
        return rp;
    }

    @Override
    public List<String> getRequiredParameters() {
        return this.getParameters(false);
    }

    @Override
    public List<String> getOptionalParameters() {
        return this.getParameters(true);
    }

    @Override
    public boolean isParameterRequired(String name) throws NonExistentParameterException {
        for (Parameter p : this.parameters) {
            if (p.name.compareTo(name) != 0) continue;
            return !p.optional;
        }
        throw new NonExistentParameterException("Parameter not found: " + name);
    }

    @Override
    public boolean hasParameter(String name) {
        Parameter p = new Parameter(name, false);
        return this.parameters.contains(p);
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    protected static class Parameter {
        public String name;
        boolean optional;

        public Parameter() {
        }

        public Parameter(String name, boolean optional) {
            this.name = name;
            this.optional = optional;
        }

        public boolean equals(Object p) {
            if (p == null) {
                return false;
            }
            if (!(p instanceof Parameter)) {
                return false;
            }
            return this.name.compareTo(((Parameter)p).name) == 0;
        }
    }
}

