/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private Logger logger = LoggerFactory.getLogger((String)QueryParser.class.getName());
    private String terms = "";
    private Map<String, String> params;
    private String fixedTerms;
    private Map<String, String> fixedParamsMap;
    private Set<String> namespaces;
    private Pattern queryPattern = Pattern.compile("[^=]*=\"[^\"]*\"");
    private Pattern paramPattern = Pattern.compile("[^:]*:[^=]*=");
    private Pattern valuePattern = Pattern.compile("\"[^\"]*\"$");

    public QueryParser(String queryString, String[] fixedParams) throws UnsupportedEncodingException {
        this.params = new HashMap<String, String>();
        this.namespaces = new HashSet<String>();
        ArrayList<String> paramList = new ArrayList<String>();
        Matcher queryMatcher = this.queryPattern.matcher(queryString);
        while (queryMatcher.find()) {
            paramList.add(queryMatcher.group().trim());
        }
        for (String param : paramList) {
            Matcher paramMatcher = this.paramPattern.matcher(param);
            ArrayList<String> keyValue = new ArrayList<String>();
            while (paramMatcher.find()) {
                String tmp = paramMatcher.group().trim();
                keyValue.add(tmp.substring(0, tmp.length() - 1));
            }
            if (keyValue.size() != 1) {
                if (param.trim().equals("")) continue;
                this.logger.warn("Ignored malformed query parameter: " + param);
                continue;
            }
            Matcher valueMatcher = this.valuePattern.matcher(param);
            while (valueMatcher.find()) {
                keyValue.add(valueMatcher.group().trim());
            }
            if (keyValue.size() != 2) {
                if (param.trim().equals("")) continue;
                this.logger.warn("Ignored malformed query parameter: " + param);
                continue;
            }
            if (((String)keyValue.get(1)).charAt(0) != '\"' || ((String)keyValue.get(1)).charAt(((String)keyValue.get(1)).length() - 1) != '\"') {
                this.logger.warn("In parameter: " + param + ": Parameter value not enclosed in double quotes. Ignoring parameter");
                continue;
            }
            if (((String)keyValue.get(0)).compareTo(OpenSearchConstants.searchTermsQName) != 0) {
                this.params.put((String)keyValue.get(0), ((String)keyValue.get(1)).substring(1, ((String)keyValue.get(1)).length() - 1));
            } else {
                this.terms = ((String)keyValue.get(1)).substring(1, ((String)keyValue.get(1)).length() - 1);
            }
            this.namespaces.add(URLDecoder.decode(((String)keyValue.get(0)).substring(0, ((String)keyValue.get(0)).indexOf(58)), "UTF-8"));
        }
        this.fixedParamsMap = new HashMap<String, String>();
        this.fixedTerms = "";
        for (String fixedParam : fixedParams) {
            Matcher paramMatcher = this.paramPattern.matcher(fixedParam);
            ArrayList<String> keyValue = new ArrayList<String>();
            while (paramMatcher.find()) {
                String tmp = paramMatcher.group().trim();
                keyValue.add(tmp.substring(0, tmp.length() - 1));
            }
            if (keyValue.size() != 1) {
                if (fixedParam.trim().equals("")) continue;
                this.logger.warn("Ignored malformed fixed parameter: " + fixedParam);
                continue;
            }
            Matcher valueMatcher = this.valuePattern.matcher(fixedParam);
            while (valueMatcher.find()) {
                keyValue.add(valueMatcher.group().trim());
            }
            if (keyValue.size() != 2) {
                if (fixedParam.trim().equals("")) continue;
                this.logger.warn("Ignored malformed fixed parameter: " + fixedParam);
                continue;
            }
            if (((String)keyValue.get(0)).compareTo(OpenSearchConstants.searchTermsQName) != 0) {
                this.fixedParamsMap.put((String)keyValue.get(0), ((String)keyValue.get(1)).substring(1, ((String)keyValue.get(1)).length() - 1));
            } else {
                this.fixedTerms = ((String)keyValue.get(1)).substring(1, ((String)keyValue.get(1)).length() - 1);
            }
            this.namespaces.add(URLDecoder.decode(((String)keyValue.get(0)).substring(0, ((String)keyValue.get(0)).indexOf(58)), "UTF-8"));
        }
    }

    public String getTerms() {
        return this.terms;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getFixedTerms() {
        return this.fixedTerms;
    }

    public Map<String, String> getFixedParamsMap() {
        return this.fixedParamsMap;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }
}

