/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.urlelements;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import org.gcube.opensearch.opensearchlibrary.query.BasicQueryBuilder;
import org.gcube.opensearch.opensearchlibrary.query.BasicURLTemplate;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class BasicURLElement
implements URLElement {
    private Element url;
    private BasicURLTemplate template = null;
    private Map<String, String> nsPrefixes = null;
    private String MIMEType = null;
    protected String rel = null;
    private int indexOffset;
    private int pageOffset;
    private boolean init = false;
    private static final List<String> supportedRels = Arrays.asList("results", "suggestions", "self", "collection");

    private void extractTemplate() throws Exception {
        Attr n = this.url.getAttributeNode("template");
        if (n == null) {
            throw new Exception("Url element lacks template attribute");
        }
        try {
            this.template = new BasicURLTemplate(n.getNodeValue(), this.nsPrefixes);
        }
        catch (Exception e) {
            throw new Exception("Malformed URL template", e);
        }
    }

    private void extractType() throws Exception {
        Attr n = this.url.getAttributeNode("type");
        if (n == null) {
            throw new Exception("URL element lacks type attribute");
        }
        try {
            new MimeType(n.getNodeValue().trim());
        }
        catch (Exception e) {
            throw new Exception("Malformed MIME type", e);
        }
        this.MIMEType = n.getNodeValue();
    }

    private void extractRel() throws Exception {
        Attr n = this.url.getAttributeNode("rel");
        if (n != null) {
            String tmp = n.getNodeValue().trim();
            if (tmp.compareTo("results") == 0 || tmp.compareTo("") == 0) {
                this.rel = "results";
            }
            this.rel = tmp;
        } else {
            this.rel = "results";
        }
    }

    private void extractIndexOffset() throws Exception {
        Attr n = this.url.getAttributeNode("indexOffset");
        if (n != null) {
            try {
                this.indexOffset = Integer.parseInt(n.getNodeValue().trim());
            }
            catch (Exception e) {
                throw new Exception("Invalid indexOffset value", e);
            }
        } else {
            this.indexOffset = 1;
        }
    }

    private void extractPageOffset() throws Exception {
        Attr n = this.url.getAttributeNode("pageOffset");
        if (n != null) {
            try {
                this.pageOffset = Integer.parseInt(n.getNodeValue().trim());
            }
            catch (Exception e) {
                throw new Exception("Invalid pageOffset value", e);
            }
        } else {
            this.pageOffset = 1;
        }
    }

    public BasicURLElement(Element url, Map<String, String> nsPrefixes) {
        this.url = url;
        this.nsPrefixes = nsPrefixes;
    }

    @Override
    public void parse() throws Exception {
        if (this.init) {
            return;
        }
        this.extractTemplate();
        this.extractType();
        this.extractIndexOffset();
        this.extractPageOffset();
        this.extractRel();
        this.init = true;
    }

    @Override
    public String getMimeType() throws Exception {
        if (!this.init) {
            throw new Exception("URL element not initialized");
        }
        return this.MIMEType;
    }

    @Override
    public int getIndexOffset() throws Exception {
        if (!this.init) {
            throw new Exception("URL element not initialized");
        }
        return this.indexOffset;
    }

    @Override
    public int getPageOffset() throws Exception {
        if (!this.init) {
            throw new Exception("URL element not initialized");
        }
        return this.pageOffset;
    }

    @Override
    public String getRel() throws Exception {
        if (!this.init) {
            throw new Exception("URL element not initialized");
        }
        return this.rel;
    }

    @Override
    public boolean isRelSupported() throws Exception {
        if (!this.init) {
            throw new Exception("URL element not initialized");
        }
        return supportedRels.contains(this.rel);
    }

    @Override
    public QueryBuilder getQueryBuilder() throws Exception {
        return new BasicQueryBuilder(this.template, Integer.valueOf(this.indexOffset).toString(), Integer.valueOf(this.pageOffset).toString());
    }
}

