/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.resource;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.is.InformationSystem;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISOpenSearchResource
implements OpenSearchResource {
    private Logger logger = LoggerFactory.getLogger((String)ISOpenSearchResource.class.getName());
    private EnvHintCollection envHints = null;
    private String DDUrl = null;
    private Document descriptionDocument = null;
    private String name = null;
    private boolean brokeredResults = false;
    private boolean security = false;
    private Map<String, TransformationSpec> transformationSpecs = new LinkedHashMap<String, TransformationSpec>();
    private Map<String, String> parameters = new HashMap<String, String>();

    private String stripBodyElement(String xml) throws Exception {
        String result = xml;
        int indexStart = xml.indexOf("<Body>");
        if (indexStart != 1) {
            int bodyLength = "<Body>".length();
            if (indexStart != 0) {
                throw new Exception("Found Body start tag at a position different than 0");
            }
            int indexEnd = xml.lastIndexOf("</Body>");
            if (indexEnd == -1) {
                throw new Exception("Could not find Body end tag");
            }
            if (indexEnd + bodyLength != xml.length() - 1) {
                throw new Exception("Extra characters after Body element end tag");
            }
            result = xml.substring(indexStart + bodyLength, indexEnd).trim();
        }
        return result;
    }

    private void parse(String xml, Map<String, String> descriptionDocs, Map<String, String> resourcesXML, Map<String, String> XSLTs) throws Exception {
        Node n;
        String tmp;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element rootNode = document.getDocumentElement();
        if (xml.indexOf("<Body>") == 0) {
            rootNode = (Element)document.getElementsByTagName("Body").item(0);
        }
        this.name = rootNode.getElementsByTagName("name").item(0).getFirstChild().getNodeValue();
        this.DDUrl = rootNode.getElementsByTagName("descriptionDocumentURI").item(0).getFirstChild().getNodeValue();
        URL DDURL = new URL(this.DDUrl);
        if (resourcesXML != null) {
            resourcesXML.put(this.DDUrl, xml);
        }
        if ((tmp = rootNode.getElementsByTagName("brokeredResults").item(0).getFirstChild().getNodeValue()).compareToIgnoreCase("true") == 0 || tmp.compareTo("1") == 0) {
            this.brokeredResults = true;
        }
        this.security = (n = rootNode.getElementsByTagName("security").item(0)) != null;
        NodeList paramsNl = ((Element)document.getElementsByTagName("parameters").item(0)).getElementsByTagName("parameter");
        for (int i = 0; i < paramsNl.getLength(); ++i) {
            Element param = (Element)paramsNl.item(i);
            this.parameters.put(param.getElementsByTagName("fieldName").item(0).getFirstChild().getNodeValue(), param.getElementsByTagName("qName").item(0).getFirstChild().getNodeValue());
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        XPathFactory xpFactory = XPathFactory.newInstance();
        int count = 0;
        int found = 0;
        NodeList nl = rootNode.getElementsByTagName("transformation");
        while ((n = nl.item(count)) != null) {
            String xmlRes;
            Transformer transformer;
            String xsltLink;
            XPathExpression recordSplitExpr;
            XPathExpression recordIdExpr;
            Node ch;
            String MIMEType;
            block28: {
                ++count;
                MIMEType = null;
                ch = ((Element)n).getElementsByTagName("MIMEType").item(0);
                MIMEType = ch.getFirstChild().getNodeValue();
                try {
                    new MimeType(MIMEType);
                }
                catch (Exception e) {
                    this.logger.warn("Malformed MIME type in transformation element in resource " + this.name + ". Ignoring element.", (Throwable)e);
                    continue;
                }
                ch = ((Element)n).getElementsByTagName("recordIdXPath").item(0);
                recordIdExpr = null;
                if (ch != null) {
                    try {
                        XPath xpath = xpFactory.newXPath();
                        recordIdExpr = xpath.compile(ch.getFirstChild().getNodeValue());
                    }
                    catch (Exception e) {
                        this.logger.warn("Malformed record id XPath expression in transformation element for " + MIMEType + " in resource " + this.name + ". Ignoring element.", (Throwable)e);
                        continue;
                    }
                }
                ch = ((Element)n).getElementsByTagName("recordSplitXPath").item(0);
                try {
                    XPath xpath = xpFactory.newXPath();
                    recordSplitExpr = xpath.compile(ch.getFirstChild().getNodeValue());
                }
                catch (Exception e) {
                    this.logger.warn("Malformed record split XPath expression in transformation element for " + MIMEType + " in resource " + this.name + ". Ignoring element.", (Throwable)e);
                    continue;
                }
                ch = ((Element)n).getElementsByTagName("XSLTLink").item(0);
                xsltLink = null;
                if (ch != null) {
                    xsltLink = ch.getFirstChild().getNodeValue();
                }
                transformer = null;
                xmlRes = null;
                try {
                    if (xsltLink == null) break block28;
                    if (XSLTs != null) {
                        xmlRes = XSLTs.get(xsltLink);
                    }
                    if (xmlRes != null) break block28;
                    List xmlRess = InformationSystem.GetGenericByName((String)xsltLink, (EnvHintCollection)this.envHints);
                    if (xmlRess.size() > 1) {
                        this.logger.warn("Found more than one generic resources with name " + xsltLink + ". Keeping first");
                    }
                    xmlRes = ((String)xmlRess.get(0)).trim();
                    xmlRes = this.stripBodyElement(xmlRes);
                    if (XSLTs == null) break block28;
                    XSLTs.put(xsltLink, xmlRes);
                }
                catch (Exception e) {
                    this.logger.warn("Error while retrieving and processing XSLT source. Ignoring transformation element", (Throwable)e);
                    continue;
                }
            }
            try {
                transformer = xsltLink != null ? tf.newTransformer(new StreamSource(new BufferedReader(new StringReader(xmlRes)))) : tf.newTransformer();
            }
            catch (Exception e) {
                this.logger.warn("Error while parsing XSLT source for " + MIMEType + " for resource " + this.name + ". Ignoring transformation element.", (Throwable)e);
                continue;
            }
            HashMap<String, String> presentationInfo = new HashMap<String, String>();
            ch = ((Element)n).getElementsByTagName("presentationInfo").item(0);
            NodeList presentables = ((Element)ch).getElementsByTagName("presentable");
            for (int i = 0; i < presentables.getLength(); ++i) {
                String presentableName = ((Element)presentables.item(i)).getElementsByTagName("fieldName").item(0).getFirstChild().getNodeValue();
                String presentableXPath = ((Element)presentables.item(i)).getElementsByTagName("expression").item(0).getFirstChild().getNodeValue();
                presentationInfo.put(presentableName, presentableXPath);
            }
            this.transformationSpecs.put(MIMEType, new TransformationSpec(transformer, recordSplitExpr, recordIdExpr, presentationInfo));
            ++found;
        }
        if (found == 0) {
            this.logger.error("Could not retrieve a valid transformation specification for resource " + this.name + ". Throwing exception.");
            throw new Exception("Could not retrieve a valid transformation specification for resource " + this.name);
        }
        try {
            String ddXML = null;
            if (descriptionDocs != null) {
                ddXML = descriptionDocs.get(this.DDUrl);
            }
            if (ddXML != null) {
                this.descriptionDocument = builder.parse(new InputSource(new StringReader(ddXML)));
            } else {
                String line;
                URLConnection conn = new URL(this.DDUrl).openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                ddXML = new String();
                while ((line = in.readLine()) != null) {
                    ddXML = ddXML + line;
                }
                in.close();
                this.descriptionDocument = builder.parse(new InputSource(new StringReader(ddXML)));
                if (descriptionDocs != null) {
                    descriptionDocs.put(this.DDUrl, ddXML);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while processing Description Document of resource " + this.name);
            throw e;
        }
    }

    public ISOpenSearchResource(String xml, Map<String, String> cachedDescriptionDocs, Map<String, String> cachedResourcesXML, Map<String, String> cachedXSLTs, EnvHintCollection envHints) throws Exception {
        this.envHints = envHints;
        this.parse(xml.trim(), cachedDescriptionDocs, cachedResourcesXML, cachedXSLTs);
    }

    public ISOpenSearchResource(String xml, EnvHintCollection envHints) throws Exception {
        this(xml, null, null, null, envHints);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isBrokered() {
        return this.brokeredResults;
    }

    @Override
    public boolean isSecure() {
        return this.security;
    }

    @Override
    public String getSecuritySpecs() {
        return null;
    }

    @Override
    public Document getDescriptionDocument() {
        return this.descriptionDocument;
    }

    @Override
    public String getDescriptionDocURL() {
        return this.DDUrl;
    }

    @Override
    public Transformer getTransformer(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        return this.transformationSpecs.get((Object)MIMEType).transformer;
    }

    @Override
    public XPathExpression getRecordSplitXPath(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        return this.transformationSpecs.get((Object)MIMEType).splitXPath;
    }

    @Override
    public XPathExpression getRecordIdXPath(String MIMEType) throws Exception {
        try {
            new MimeType(MIMEType);
        }
        catch (Exception e) {
            this.logger.error("Malformed MIME Type.", (Throwable)e);
            throw new Exception("Malformed MIME Type");
        }
        return this.transformationSpecs.get((Object)MIMEType).idXPath;
    }

    @Override
    public Transformer getTransformer() throws Exception {
        return this.transformationSpecs.get(this.transformationSpecs.keySet().iterator()).transformer;
    }

    @Override
    public Map<String, String> getPresentationInformation(String MIMEType) {
        return this.transformationSpecs.get((Object)MIMEType).presentationInfo;
    }

    @Override
    public List<String> getTransformationTypes() {
        return new ArrayList<String>(this.transformationSpecs.keySet());
    }

    @Override
    public String getParameterQName(String fieldName) {
        return this.parameters.get(fieldName);
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    private class TransformationSpec {
        public final Transformer transformer;
        public final XPathExpression idXPath;
        public final XPathExpression splitXPath;
        public final Map<String, String> presentationInfo;

        public TransformationSpec(Transformer transformer, XPathExpression splitXPath, XPathExpression idXPath, Map<String, String> presentationInfo) {
            this.splitXPath = splitXPath;
            this.transformer = transformer;
            this.idXPath = idXPath;
            this.presentationInfo = presentationInfo;
        }
    }
}

