/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.utils;

import java.util.Collection;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryClassNamePair;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryPair;

public class FactoryResolver {
    private static Collection<String> queryNamespaces = null;
    private static Map<String, FactoryClassNamePair> factories = null;

    private FactoryResolver() {
    }

    public static void initialize(Collection<String> queryNamespaces, Map<String, FactoryClassNamePair> factories) {
        FactoryResolver.queryNamespaces = queryNamespaces;
        FactoryResolver.factories = factories;
    }

    public static FactoryPair getFactories() throws Exception {
        if (queryNamespaces == null || factories == null) {
            throw new Exception("Factory resolver not initialized");
        }
        if (!factories.containsKey("http://a9.com/-/spec/opensearch/1.1/")) {
            throw new Exception("Base-type factory is not specified");
        }
        URLElementFactory urlf = (URLElementFactory)Class.forName(FactoryResolver.factories.get((Object)"http://a9.com/-/spec/opensearch/1.1/").urlElementFactoryClass).newInstance();
        QueryElementFactory queryf = (QueryElementFactory)Class.forName(FactoryResolver.factories.get((Object)"http://a9.com/-/spec/opensearch/1.1/").queryElementFactoryClass).newInstance();
        for (String namespace : queryNamespaces) {
            if (namespace.equals("http://a9.com/-/spec/opensearch/1.1/") || !factories.containsKey(namespace)) continue;
            urlf = (URLElementFactory)Class.forName(FactoryResolver.factories.get((Object)namespace).urlElementFactoryClass).getConstructors()[0].newInstance(urlf);
            queryf = (QueryElementFactory)Class.forName(FactoryResolver.factories.get((Object)namespace).queryElementFactoryClass).getConstructors()[0].newInstance(queryf);
        }
        return new FactoryPair(urlf, queryf);
    }
}

