/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.ImageElement;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElement;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchlibrary.utils.SyndicationRight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DescriptionDocument {
    private Logger logger = LoggerFactory.getLogger((String)DescriptionDocument.class.getName());
    private Document descriptionDocument = null;
    private Map<String, String> reverseNSMappings = new HashMap<String, String>();
    private Map<String, String> NSMappings = new HashMap<String, String>();
    private String shortName = null;
    private String longName = null;
    private String description = null;
    private List<URLElement> urlElements = null;
    private List<QueryElement> queryElements = null;
    private String contact = null;
    private List<String> tags = null;
    private String developer = null;
    private String attribution = null;
    private SyndicationRight syndication = null;
    private Boolean adultContent = null;
    private List<String> lang = null;
    private List<ImageElement> images = null;
    private List<String> inputEncoding = null;
    private List<String> outputEncoding = null;
    private final String defaultInputEncoding = "UTF-8";
    private final String defaultOutputEncoding = "UTF-8";

    private void extractNSMappings() {
        NamedNodeMap nnm = this.descriptionDocument.getDocumentElement().getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            String NSUrl = nnm.item(i).getNodeValue();
            String prefix = nnm.item(i).getLocalName();
            if (prefix.compareTo("xmlns") != 0) {
                this.reverseNSMappings.put(NSUrl, prefix);
                this.NSMappings.put(prefix, NSUrl);
                continue;
            }
            this.NSMappings.put("", "http://a9.com/-/spec/opensearch/1.1/");
        }
    }

    public String getNSPrefix(String NSUrl) {
        return this.reverseNSMappings.get(NSUrl);
    }

    public String getNSUrl(String NSPrefix) {
        return this.NSMappings.get(NSPrefix);
    }

    public DescriptionDocument(Document descriptionDocument, URLElementFactory urlFactory, QueryElementFactory queryFactory) throws Exception {
        this.descriptionDocument = descriptionDocument;
        if (!descriptionDocument.getDocumentElement().getNodeName().equals("OpenSearchDescription")) {
            this.logger.error("Bad document element. Throwing exception");
            throw new Exception("Bad document element");
        }
        this.extractNSMappings();
        Node n = descriptionDocument.getElementsByTagName("ShortName").item(0);
        if (n == null) {
            this.logger.error("Description Document lacks a ShortName element. Throwing exception");
            throw new Exception("Description Document lacks a ShortName element");
        }
        this.shortName = n.getFirstChild().getNodeValue();
        n = descriptionDocument.getElementsByTagName("LongName").item(0);
        if (n != null) {
            this.longName = n.getFirstChild().getNodeValue();
        }
        if ((n = descriptionDocument.getElementsByTagName("Description").item(0)) == null) {
            this.logger.warn("Description Document lacks a Description element.");
        } else {
            this.description = n.getFirstChild().getNodeValue();
        }
        this.urlElements = new ArrayList<URLElement>();
        int count = 0;
        int supported = 0;
        while ((n = descriptionDocument.getElementsByTagName("Url").item(count)) != null) {
            URLElement urlEl;
            ++count;
            try {
                urlEl = urlFactory.newInstance((Element)n, this.reverseNSMappings);
                urlEl.parse();
            }
            catch (Exception e) {
                this.logger.warn("Ignored a Url element. Cause:", (Throwable)e);
                continue;
            }
            this.urlElements.add(urlEl);
            ++supported;
        }
        if (count == 0) {
            this.logger.error("Description Document lacks URL elements. Throwing exception.");
            throw new Exception("Description Document lacks URL elements");
        }
        if (supported == 0) {
            this.logger.error("Description Document lacks valid or supported URL elements. Throwing exception");
            throw new Exception("Description Document lacks valid or supported Url elements");
        }
        count = 0;
        this.queryElements = new ArrayList<QueryElement>();
        while ((n = descriptionDocument.getElementsByTagName("Query").item(count++)) != null) {
            QueryElement queryEl;
            try {
                queryEl = queryFactory.newInstance((Element)n, this.reverseNSMappings);
                queryEl.parse();
            }
            catch (Exception e) {
                this.logger.warn("Ignored a Query element. Cause:", (Throwable)e);
                continue;
            }
            if (!queryEl.describesExampleQuery()) {
                this.logger.warn("Ignored a Query element. Cause: Query element does not describe an example query");
                continue;
            }
            this.queryElements.add(queryEl);
        }
        n = descriptionDocument.getElementsByTagName("Contact").item(0);
        if (n != null) {
            this.contact = n.getFirstChild().getNodeValue();
        }
        if ((n = descriptionDocument.getElementsByTagName("Tags").item(0)) != null) {
            this.tags = new ArrayList<String>();
            this.tags.addAll(Arrays.asList(n.getFirstChild().getNodeValue().split(" ")));
        }
        if ((n = descriptionDocument.getElementsByTagName("Developer").item(0)) != null) {
            this.developer = n.getFirstChild().getNodeValue();
        }
        if ((n = descriptionDocument.getElementsByTagName("Attribution").item(0)) != null) {
            this.attribution = n.getFirstChild().getNodeValue();
        }
        if ((n = descriptionDocument.getElementsByTagName("SyndicationRight").item(0)) != null) {
            boolean valid = false;
            String sr = n.getFirstChild().getNodeValue().trim();
            if (sr.compareToIgnoreCase("open") == 0) {
                this.syndication = SyndicationRight.OPEN;
                valid = true;
            } else if (sr.compareToIgnoreCase("limited") == 0) {
                this.syndication = SyndicationRight.LIMITED;
                valid = true;
            } else if (sr.compareToIgnoreCase("private") == 0) {
                this.syndication = SyndicationRight.PRIVATE;
                valid = true;
            } else if (sr.compareToIgnoreCase("closed") == 0) {
                this.syndication = SyndicationRight.CLOSED;
                valid = true;
            }
            if (!valid) {
                this.logger.error("Invalid value in SyndicationRight element. Throwing exception");
                throw new Exception("Invalid value in SyndicationRight element");
            }
        } else {
            this.syndication = SyndicationRight.OPEN;
        }
        if ((n = descriptionDocument.getElementsByTagName("AdultContent").item(0)) != null) {
            String ac = n.getFirstChild().getNodeValue().trim();
            this.adultContent = ac.compareTo("false") == 0 || ac.compareTo("FALSE") == 0 || ac.compareTo("no") == 0 || ac.compareTo("NO") == 0 || ac.compareTo("0") == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        count = 0;
        while ((n = descriptionDocument.getElementsByTagName("Language").item(count)) != null) {
            if (count == 0) {
                this.lang = new ArrayList<String>();
            }
            if (this.lang != null) {
                String tmp = n.getFirstChild().getNodeValue();
                if (tmp.compareTo("*") != 0) {
                    this.lang.add(n.getFirstChild().getNodeValue());
                } else {
                    this.lang = null;
                }
            }
            ++count;
        }
        count = 0;
        n = descriptionDocument.getElementsByTagName("Image").item(0);
        if (n != null) {
            this.images = new ArrayList<ImageElement>();
            this.images.add(new ImageElement((Element)n));
            ++count;
        }
        while ((n = descriptionDocument.getElementsByTagName("Image").item(count)) != null) {
            this.images.add(new ImageElement((Element)n));
            ++count;
        }
        this.inputEncoding = new ArrayList<String>();
        count = 0;
        supported = 0;
        while ((n = descriptionDocument.getElementsByTagName("InputEncoding").item(count)) != null) {
            String enc = n.getFirstChild().getNodeValue();
            if (Charset.isSupported(enc)) {
                this.inputEncoding.add(enc);
                ++supported;
            }
            ++count;
        }
        if (count == 0) {
            this.inputEncoding.add("UTF-8");
        } else if (supported == 0) {
            this.logger.error("Unsupported encoding in InputEncoding element. Throwing exception");
            throw new Exception("Unsupported encoding in InputEncoding element");
        }
        this.outputEncoding = new ArrayList<String>();
        count = 0;
        supported = 0;
        while ((n = descriptionDocument.getElementsByTagName("OutputEncoding").item(count)) != null) {
            String enc = n.getFirstChild().getNodeValue();
            if (Charset.isSupported(enc)) {
                this.outputEncoding.add(enc);
                ++supported;
            }
            ++count;
        }
        if (count == 0) {
            this.outputEncoding.add("UTF-8");
        } else if (supported == 0) {
            this.logger.error("Unsupported encoding in OutputEncoding element. Throwing exception");
            throw new Exception("Unsupported encoding in OutputEncoding element");
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContact() {
        return this.contact;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public SyndicationRight getSyndicationRight() {
        return this.syndication;
    }

    public boolean canRequest() {
        return this.syndication != SyndicationRight.CLOSED;
    }

    public boolean canSendToEndUsers() {
        return this.syndication == SyndicationRight.OPEN || this.syndication == SyndicationRight.LIMITED;
    }

    public boolean canSendToClients() {
        return this.syndication == SyndicationRight.OPEN;
    }

    public Boolean hasAdultContent() {
        return this.adultContent;
    }

    public List<String> getTags() {
        return this.tags == null ? null : new ArrayList<String>(this.tags);
    }

    public boolean hasLangRestriction() {
        return this.lang != null;
    }

    public boolean isLanguageSupported(String lang) {
        if (!this.hasLangRestriction()) {
            return true;
        }
        return this.lang.contains(lang);
    }

    public List<String> getSupportedLanguages() {
        return this.hasLangRestriction() ? new ArrayList<String>(this.lang) : null;
    }

    public boolean isInputEncodingSupported(String encoding) {
        return this.inputEncoding.contains(encoding);
    }

    public String getDefaultInputEncoding() {
        return "UTF-8";
    }

    public List<String> getSupportedInputEncodings() {
        return new ArrayList<String>(this.inputEncoding);
    }

    public boolean isOutputEncodingSupported(String encoding) {
        return this.outputEncoding.contains(encoding);
    }

    public String getDefaultOutputEncoding() {
        return "UTF-8";
    }

    public List<String> getSupportedOutputEncodings() {
        return new ArrayList<String>(this.outputEncoding);
    }

    public URI getImageURI() {
        if (this.images == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(this.images.get(0).getURI().toString());
        }
        catch (Exception e) {
            this.logger.warn("Unexpected exception caught while creating a URI copy", (Throwable)e);
        }
        return uri;
    }

    public URI getImageURI(String MIMEType) {
        if (this.images == null) {
            return null;
        }
        URI uri = null;
        int i = 0;
        while (this.images.get(i++).getMimeType().compareTo(MIMEType) != 0) {
        }
        if (i == this.images.size()) {
            i = 0;
        }
        try {
            uri = new URI(this.images.get(i).getURI().toString());
        }
        catch (Exception e) {
            this.logger.warn("Unexpected exception caught while creating a URI copy", (Throwable)e);
        }
        return uri;
    }

    public List<String> getSupportedMimeTypes(String rel) throws Exception {
        Iterator<URLElement> it = this.urlElements.iterator();
        ArrayList<String> types = null;
        int count = 0;
        while (it.hasNext()) {
            URLElement n = it.next();
            if (n.getRel().compareTo(rel) != 0) continue;
            if (count == 0) {
                types = new ArrayList<String>();
            }
            types.add(n.getMimeType());
            ++count;
        }
        return types;
    }

    public Map<String, List<String>> getUniqueTemplates() throws Exception {
        HashMap<String, List<String>> templates = new HashMap<String, List<String>>();
        ArrayList<QueryBuilder> qbs = new ArrayList<QueryBuilder>();
        for (URLElement urlEl : this.urlElements) {
            if (urlEl.getRel().compareTo("results") != 0) continue;
            if (qbs.size() == 0) {
                templates.put(urlEl.getMimeType(), new ArrayList<String>(Arrays.asList(urlEl.getQueryBuilder().getRawTemplate())));
                qbs.add(urlEl.getQueryBuilder());
                continue;
            }
            List<String> reqParams = urlEl.getQueryBuilder().getRequiredParameters();
            List<String> optParams = urlEl.getQueryBuilder().getOptionalParameters();
            for (QueryBuilder qb : qbs) {
                List<String> reqPs = urlEl.getQueryBuilder().getRequiredParameters();
                List<String> optPs = urlEl.getQueryBuilder().getOptionalParameters();
                reqPs.removeAll(qb.getRequiredParameters());
                optPs.removeAll(qb.getOptionalParameters());
                if (reqPs.isEmpty() && optPs.isEmpty()) continue;
                if (!templates.containsKey(urlEl.getMimeType())) {
                    templates.put(urlEl.getMimeType(), new ArrayList<String>(Arrays.asList(urlEl.getQueryBuilder().getRawTemplate())));
                    break;
                }
                ((List)templates.get(urlEl.getMimeType())).add(urlEl.getQueryBuilder().getRawTemplate());
                break;
            }
            qbs.add(urlEl.getQueryBuilder());
        }
        return templates;
    }

    public List<QueryBuilder> getQueryBuilders(String rel, String MIMEType) throws Exception {
        Iterator<URLElement> it = this.urlElements.iterator();
        ArrayList<QueryBuilder> qbs = new ArrayList<QueryBuilder>();
        while (it.hasNext()) {
            URLElement n = it.next();
            if (n.getRel().compareTo(rel) != 0 || n.getMimeType().compareTo(MIMEType) != 0) continue;
            qbs.add(n.getQueryBuilder());
        }
        return qbs;
    }

    public List<QueryBuilder> getExampleQueryBuilders(String MIMEType) throws Exception {
        Iterator<URLElement> urlIt = this.urlElements.iterator();
        ArrayList<QueryBuilder> qbs = new ArrayList<QueryBuilder>();
        while (urlIt.hasNext()) {
            URLElement urlN = urlIt.next();
            if (urlN.getMimeType().compareTo(MIMEType) != 0) continue;
            QueryBuilder urlQb = urlN.getQueryBuilder();
            List<String> urlParams = urlQb.getRequiredParameters();
            Iterator<QueryElement> queryIt = this.queryElements.iterator();
            while (queryIt.hasNext()) {
                Map<String, String> queryParams;
                urlQb = urlN.getQueryBuilder();
                QueryElement queryN = queryIt.next();
                if (!queryN.describesExampleQuery() || !urlParams.containsAll((queryParams = queryN.getQueryParameters()).keySet())) continue;
                for (Map.Entry<String, String> e : queryParams.entrySet()) {
                    urlQb.setParameter(e.getKey(), e.getValue());
                }
                qbs.add(urlQb);
            }
        }
        return qbs;
    }

    public Map<String, String> getNSPrefixToURIMappings() {
        return new HashMap<String, String>(this.NSMappings);
    }

    public Map<String, String> getURIToPrefixMappings() {
        return new HashMap<String, String>(this.reverseNSMappings);
    }
}

