/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator;

import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchlibrary.query.NonExistentParameterException;
import org.gcube.opensearch.opensearchlibrary.query.QueryBuilder;
import org.gcube.opensearch.opensearchlibrary.responseelements.OpenSearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pager {
    private int currPage = 0;
    private int numOfResults;
    private int totalResultCount;
    private int currentPageResultCount;
    private int clientStartPage = -1;
    private int clientStartIndex = -1;
    private int clientCount = -1;
    private int itemsPerPage;
    private List<QueryBuilder> queryBuilders = null;
    private String resourceName;
    private String MIMEType;
    private String outputEncoding;
    private Logger logger = LoggerFactory.getLogger((String)Pager.class.getName());
    private ListIterator<QueryBuilder> qbIt = null;

    private String getNextPageQuery(QueryBuilder qb) throws Exception {
        try {
            int resultsNeeded = this.numOfResults - this.totalResultCount;
            qb.setParameter(OpenSearchConstants.countQName, this.clientCount != -1 ? this.clientCount : this.itemsPerPage);
        }
        catch (NonExistentParameterException nonExistentParameterException) {
            // empty catch block
        }
        if (!qb.hasParameter(OpenSearchConstants.startPageQName) && qb.hasParameter(OpenSearchConstants.startIndexQName)) {
            qb.setParameter(OpenSearchConstants.startIndexQName, this.clientStartIndex != -1 && this.currPage == 0 ? this.clientStartIndex + this.totalResultCount : qb.getStartIndexDef() + this.totalResultCount);
        } else if (qb.hasParameter(OpenSearchConstants.startPageQName)) {
            qb.setParameter(OpenSearchConstants.startPageQName, this.clientStartPage != -1 && this.currPage == 0 ? this.clientStartPage + this.currPage : qb.getStartPageDef() + this.currPage);
        }
        return qb.getQuery();
    }

    public Pager(int numOfResults, int itemsPerPage, String resourceName, int clientStartPage, int clientStartIndex, int clientCount) {
        this.numOfResults = numOfResults;
        this.totalResultCount = 0;
        this.itemsPerPage = itemsPerPage;
        this.resourceName = resourceName;
        this.clientStartPage = clientStartPage;
        this.clientStartIndex = clientStartIndex;
        this.clientCount = clientCount;
    }

    public void setContext(List<QueryBuilder> queryBuilders, String MIMEType) {
        this.qbIt = null;
        this.queryBuilders = queryBuilders;
        this.MIMEType = MIMEType;
    }

    public URL getPageQuery() throws Exception {
        if (this.queryBuilders == null) {
            throw new Exception("No query builders are specified");
        }
        URL query = null;
        if (this.qbIt == null) {
            this.qbIt = this.queryBuilders.listIterator();
        } else {
            this.qbIt.previous();
        }
        while (this.qbIt.hasNext()) {
            QueryBuilder qb = this.qbIt.next();
            try {
                query = new URL(this.getNextPageQuery(qb));
                break;
            }
            catch (Exception e) {
                this.logger.warn("Unable to formulate query for " + this.resourceName + " MIME Type: " + this.MIMEType + " Page " + this.currPage + " Ignoring query element", (Throwable)e);
            }
        }
        if (query == null) {
            throw new Exception("Could not formulate query");
        }
        return query;
    }

    public void next(OpenSearchResponse response, int resultsRetrieved) {
        int nextPageResultCount = 0;
        if (resultsRetrieved == 0) {
            this.itemsPerPage = 0;
        } else {
            int responseItemsPerPage;
            int n = responseItemsPerPage = response.getItemsPerPage() != null ? response.getItemsPerPage() : this.itemsPerPage;
            if (response.containsPagingElements()) {
                if (response.getStartIndex() != null) {
                    nextPageResultCount = response.getTotalResults() != null ? (response.getTotalResults() < responseItemsPerPage ? 0 : (resultsRetrieved < responseItemsPerPage || this.totalResultCount + resultsRetrieved >= response.getTotalResults() ? 0 : response.getItemsPerPage())) : (!response.isLastPage() ? (response.getTotalResults() != null && this.totalResultCount + resultsRetrieved >= response.getTotalResults() ? 0 : resultsRetrieved) : 0);
                } else if (resultsRetrieved < this.itemsPerPage) {
                    nextPageResultCount = 0;
                }
                this.itemsPerPage = nextPageResultCount;
            } else if (resultsRetrieved < this.itemsPerPage) {
                this.itemsPerPage = 0;
            }
        }
        this.totalResultCount += this.itemsPerPage;
        if (this.itemsPerPage != 0) {
            this.currPage = this.totalResultCount / this.itemsPerPage;
        }
        this.currentPageResultCount = this.itemsPerPage;
    }

    public boolean hasNext() {
        if (this.itemsPerPage == 0) {
            return false;
        }
        return this.totalResultCount < this.numOfResults;
    }

    public int getTotalResultCount() {
        return this.totalResultCount;
    }

    public int getCurrentPageResultCount() {
        return this.currentPageResultCount;
    }

    public QueryBuilder getQueryBuilder() {
        this.qbIt.previous();
        if (this.qbIt != null) {
            return this.qbIt.next();
        }
        return null;
    }

    public int getCurrPage() {
        return this.currPage;
    }
}

