/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.service.helpers;

import com.google.common.collect.Sets;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchOperator;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.queryelements.BasicQueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.BasicURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.rest.opensearch.common.discover.OpenSearchDiscovererAPI;
import org.gcube.rest.opensearch.common.discover.exceptions.OpenSearchDiscovererException;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRefresher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CacheRefresher.class);
    private long lastRefresh;
    private long refreshIntervalMillis;
    private long cycleCount;
    private boolean forceRefresh;
    private Object synchMe = null;
    private final OpenSearchOperator openSearchOperator;
    private final OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer;
    private final String scope;
    private final String hostname;

    public CacheRefresher(long refreshIntervalMillis, OpenSearchOperator openSearchOperator, OpenSearchDiscovererAPI<OpenSearchDataSourceResource> discoverer, String hostname, String scope) {
        if (refreshIntervalMillis < 0L) {
            throw new IllegalArgumentException("Negative time interval value");
        }
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.cycleCount = 1L;
        this.synchMe = new Object();
        this.forceRefresh = false;
        this.openSearchOperator = openSearchOperator;
        this.discoverer = discoverer;
        this.hostname = hostname;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lastRefresh = Calendar.getInstance().getTimeInMillis();
        long millisSinceLastRefresh = 0L;
        long nextRefresh = this.refreshIntervalMillis;
        while (true) {
            int refreshCount = 0;
            int failed = 0;
            if (this.refreshIntervalMillis != 0L) {
                logger.debug("Next cache refresh in " + (nextRefresh - millisSinceLastRefresh) + " milliseconds");
            } else {
                millisSinceLastRefresh = Integer.MIN_VALUE;
            }
            boolean explicitRefreshRequested = false;
            while (millisSinceLastRefresh < nextRefresh) {
                Object object = this.synchMe;
                synchronized (object) {
                    try {
                        if (this.refreshIntervalMillis != 0L) {
                            this.synchMe.wait(nextRefresh - millisSinceLastRefresh);
                        } else {
                            this.synchMe.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.forceRefresh) {
                        this.forceRefresh = false;
                        explicitRefreshRequested = true;
                        millisSinceLastRefresh = Calendar.getInstance().getTimeInMillis() - this.lastRefresh;
                        nextRefresh = this.refreshIntervalMillis - millisSinceLastRefresh;
                        break;
                    }
                }
                if (this.refreshIntervalMillis == 0L) continue;
                millisSinceLastRefresh = Calendar.getInstance().getTimeInMillis() - this.lastRefresh;
            }
            if (!explicitRefreshRequested) {
                nextRefresh = this.refreshIntervalMillis;
                this.lastRefresh = Calendar.getInstance().getTimeInMillis();
                logger.debug("Starting generic resource cache refresh cycle #" + this.cycleCount);
            } else {
                logger.debug("Forced to start generic resource cache refresh");
            }
            millisSinceLastRefresh = 0L;
            Set resources = Sets.newHashSet();
            try {
                resources = this.discoverer.discoverOpenSearchResourcesLocal(this.scope, this.hostname);
            }
            catch (OpenSearchDiscovererException e1) {
                logger.error("error in local resource discovery", (Throwable)e1);
            }
            for (OpenSearchDataSourceResource resource : resources) {
                ISOpenSearchResourceCache cache = resource.cache;
                List ddURIs = resource.getDescriptionDocumentURI();
                List genericResourceIds = resource.getOpenSearchResource();
                String scope = resource.getScope();
                EnvHintCollection envHints = resource.getISEnvHints();
                int providerCount = resource.getCollectionID().size();
                String[] genericResourceXML = new String[providerCount];
                boolean genericResourceFail = false;
                for (int i = 0; i < providerCount; ++i) {
                    try {
                        genericResourceXML[i] = this.openSearchOperator.retrieveGenericResource((String)genericResourceIds.get(i), scope).toString();
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to retrieve generic resource with id " + (String)genericResourceIds.get(i) + ". Skipping cache refreshing for this resource", (Throwable)e);
                        genericResourceFail = true;
                        break;
                    }
                }
                if (genericResourceFail) continue;
                ISOpenSearchResourceCache iSOpenSearchResourceCache = cache;
                synchronized (iSOpenSearchResourceCache) {
                    int i;
                    ISOpenSearchResource[] savedResources = new ISOpenSearchResource[providerCount];
                    String[] savedDdUris = new String[providerCount];
                    for (i = 0; i < providerCount; ++i) {
                        savedResources[i] = resource.openSearchGenericResources[i];
                        savedDdUris[i] = (String)resource.getDescriptionDocumentURI().get(i);
                    }
                    cache.descriptionDocuments.clear();
                    cache.resources.clear();
                    cache.resourcesXML.clear();
                    cache.XSLTs.clear();
                    for (i = 0; i < providerCount; ++i) {
                        boolean fail = false;
                        try {
                            resource.openSearchGenericResources[i] = new ISOpenSearchResource(genericResourceXML[i], cache.descriptionDocuments, cache.resourcesXML, cache.XSLTs, envHints);
                        }
                        catch (Exception e) {
                            logger.warn("Could not create OpenSearch resource instance during cache refreshing. Using old instance.", (Throwable)e);
                            fail = true;
                        }
                        cache.resources.put(ddURIs.get(i), resource.openSearchGenericResources[i]);
                        if (!fail) {
                            DescriptionDocument dd = null;
                            ddURIs.add(resource.openSearchGenericResources[i].getDescriptionDocURL());
                            try {
                                dd = new DescriptionDocument(resource.openSearchGenericResources[i].getDescriptionDocument(), (URLElementFactory)new BasicURLElementFactory(), (QueryElementFactory)new BasicQueryElementFactory());
                            }
                            catch (Exception e) {
                                logger.warn("Could not create Description Document instance during cache refreshing. Using old OpenSearch resource instance.", (Throwable)e);
                                fail = true;
                            }
                            if (!fail && !fail) {
                                try {
                                    if (i == 0) {
                                        resource.setDescriptionDocumentURI((String)ddURIs.get(i));
                                    } else {
                                        resource.getDescriptionDocumentURI().add(ddURIs.get(i));
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Could not update WS resource with the new Description Document URI. Using old OpenSearch resource instance", (Throwable)e);
                                    fail = true;
                                }
                            }
                            if (fail) {
                                Exception ex = null;
                                try {
                                    cache.resources.clear();
                                    for (int j = 0; j < providerCount; ++j) {
                                        resource.openSearchGenericResources[j] = savedResources[j];
                                        resource.setDescriptionDocumentURI(Arrays.asList(savedDdUris));
                                        cache.resources.put(savedDdUris[j], savedResources[j]);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Failed to revert to old state after failure of cache refresh for WS resource bound to generic resources with ids " + genericResourceIds);
                                    ex = e;
                                }
                                if (ex != null) continue;
                                logger.warn("Failed to refresh cache for WS resource bound to generic resources with ids " + genericResourceIds);
                                continue;
                            }
                            ++refreshCount;
                            continue;
                        }
                        ++failed;
                    }
                    logger.debug("Refreshed cache and updated state of WS resource bound to generic resources with ids " + genericResourceIds);
                }
            }
            if (!explicitRefreshRequested) {
                logger.debug("Ended generic resource cache refresh cycle #" + this.cycleCount);
                ++this.cycleCount;
            } else {
                logger.debug("Ended forced generic resource cache refreshing");
            }
            logger.debug("Total generic resource caches refreshed: " + refreshCount);
            logger.debug("Total generic resource cache refresh operations failed: " + failed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRefresh() {
        Object object = this.synchMe;
        synchronized (object) {
            this.forceRefresh = true;
            this.synchMe.notify();
        }
    }
}

